/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.scripts;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.BaseRemoteFileEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.JavaScriptDebuggerViewSupport;
import com.jetbrains.javascript.debugger.scripts.ConsumerOnEdt;
import com.jetbrains.javascript.debugger.scripts.Scripts;
import com.jetbrains.javascript.debugger.scripts.VmScriptFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.Vm;

class VmFileEditor
extends BaseRemoteFileEditor {
    private TextEditor textEditor;
    private final JBLoadingPanel loadingPanel;
    private volatile boolean isValid;

    public VmFileEditor(@NotNull Project project, @NotNull VmScriptFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/scripts/VmFileEditor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/javascript/debugger/scripts/VmFileEditor", "<init>"));
        }
        super(project);
        this.isValid = true;
        this.loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 300);
        this.loadingPanel.startLoading();
        for (JavaScriptDebugProcess debugProcess : XDebuggerManager.getInstance((Project)project).getDebugProcesses(JavaScriptDebugProcess.class)) {
            Promise source;
            JavaScriptDebuggerViewSupport viewSupport = debugProcess.getDebuggerViewSupport();
            Vm vm = viewSupport.getVm();
            if (vm == null || (source = vm.getScriptManager().getSource(file.getScript())).getState() == Promise.State.REJECTED) continue;
            this.download(file, (DebuggerViewSupport)viewSupport);
            return;
        }
        this.loadingPanel.stopLoading();
        this.isValid = false;
    }

    private void download(@NotNull VmScriptFile file, @NotNull DebuggerViewSupport debugProcess) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/javascript/debugger/scripts/VmFileEditor", "download"));
        }
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/javascript/debugger/scripts/VmFileEditor", "download"));
        }
        Scripts.ensureDownloaded(file, debugProcess.getVm()).done((Consumer)new ConsumerOnEdt<VirtualFile>(this.myProject){

            @Override
            public void consume(@NotNull Project project, VirtualFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/scripts/VmFileEditor$2", "consume"));
                }
                VmFileEditor.this.loadingPanel.stopLoading();
                VmFileEditor.this.textEditor = (TextEditor)TextEditorProvider.getInstance().createEditor(project, file);
                VmFileEditor.this.contentLoaded();
                VmFileEditor.this.textEditor.addPropertyChangeListener((PropertyChangeListener)((Object)VmFileEditor.this));
                VmFileEditor.this.loadingPanel.add((Component)VmFileEditor.this.textEditor.getComponent());
            }
        }).rejected((Consumer)new Consumer<Throwable>(){

            public void consume(Throwable error) {
                VmFileEditor.this.loadingPanel.stopLoading();
                VmFileEditor.this.isValid = false;
                VmFileEditor.this.contentRejected();
            }
        });
    }

    public boolean isValid() {
        return this.isValid;
    }

    @NotNull
    public JComponent getComponent() {
        JBLoadingPanel jBLoadingPanel = this.loadingPanel;
        if (jBLoadingPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/VmFileEditor", "getComponent"));
        }
        return jBLoadingPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.textEditor == null ? this.loadingPanel : this.textEditor.getPreferredFocusedComponent();
    }

    @NotNull
    public String getName() {
        if ("Vm" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/VmFileEditor", "getName"));
        }
        return "Vm";
    }

    public void selectNotify() {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (VmFileEditor.this.textEditor != null) {
                    VmFileEditor.this.textEditor.selectNotify();
                }
            }
        });
    }

    public void deselectNotify() {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (VmFileEditor.this.textEditor != null) {
                    VmFileEditor.this.textEditor.deselectNotify();
                }
            }
        });
    }

    @Nullable
    protected TextEditor getTextEditor() {
        return this.textEditor;
    }

    public void dispose() {
        super.dispose();
        if (this.textEditor != null) {
            Disposer.dispose((Disposable)this.textEditor);
        }
    }
}

