/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.sourcemap;

import com.intellij.util.Url;
import com.intellij.util.containers.BidirectionalMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0005H\u0007J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0005H\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0005H\u0007J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u0005H\u0007J\u001c\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0018H\u0007R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/javascript/debugger/sourcemap/PreloadedSourceMapList;", "", "()V", "scriptUrlToSourceMap", "Lgnu/trove/THashMap;", "Lcom/intellij/util/Url;", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "getScriptUrlToSourceMap", "()Lgnu/trove/THashMap;", "sourceMapUrlToSourceMap", "Lcom/intellij/util/containers/BidirectionalMap;", "add", "", "mapUrl", "map", "scriptUrl", "containsMap", "containsScript", "get", "url", "getByScript", "process", "", "procedure", "Lgnu/trove/TObjectObjectProcedure;", "JavaScriptDebugger"})
public final class PreloadedSourceMapList {
    @NotNull
    private final THashMap<Url, SourceMap> scriptUrlToSourceMap = new THashMap();
    private final BidirectionalMap<Url, SourceMap> sourceMapUrlToSourceMap = new BidirectionalMap();

    @NotNull
    public final THashMap<Url, SourceMap> getScriptUrlToSourceMap() {
        return this.scriptUrlToSourceMap;
    }

    public final synchronized boolean add(@NotNull Url mapUrl, @NotNull SourceMap map, @NotNull Url scriptUrl) {
        Intrinsics.checkParameterIsNotNull((Object)mapUrl, (String)"mapUrl");
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        Intrinsics.checkParameterIsNotNull((Object)scriptUrl, (String)"scriptUrl");
        if (this.scriptUrlToSourceMap.containsKey((Object)scriptUrl)) {
            return false;
        }
        this.sourceMapUrlToSourceMap.put((Object)mapUrl, (Object)map);
        this.scriptUrlToSourceMap.put((Object)scriptUrl, (Object)map);
        return true;
    }

    @Nullable
    public final synchronized SourceMap get(@NotNull Url url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        return (SourceMap)this.sourceMapUrlToSourceMap.get((Object)url);
    }

    @Nullable
    public final synchronized SourceMap getByScript(@NotNull Url scriptUrl) {
        Intrinsics.checkParameterIsNotNull((Object)scriptUrl, (String)"scriptUrl");
        return (SourceMap)this.scriptUrlToSourceMap.get((Object)scriptUrl);
    }

    public final synchronized boolean containsMap(@NotNull SourceMap map) {
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        return this.sourceMapUrlToSourceMap.containsValue((Object)map);
    }

    public final synchronized boolean containsScript(@NotNull Url scriptUrl) {
        Intrinsics.checkParameterIsNotNull((Object)scriptUrl, (String)"scriptUrl");
        return this.scriptUrlToSourceMap.containsKey((Object)scriptUrl);
    }

    public final synchronized void process(@NotNull TObjectObjectProcedure<Url, SourceMap> procedure) {
        Intrinsics.checkParameterIsNotNull(procedure, (String)"procedure");
        this.scriptUrlToSourceMap.forEachEntry(procedure);
    }
}

