/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.sourcemap;

import com.google.common.collect.BiMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.UrlImpl;
import com.intellij.util.Urls;
import com.intellij.util.io.URLUtil;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcessKt;
import com.jetbrains.javascript.debugger.sourcemap.PreloadedSourceMapList;
import com.jetbrains.javascript.debugger.sourcemap.SourceMapCollector;
import com.jetbrains.javascript.debugger.sourcemap.SourceMapCollectorKt;
import com.jetbrains.javascript.debugger.sourcemap.SourceMapLoaderKt;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\nH\u0002R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/javascript/debugger/sourcemap/SourceMapCollector;", "", "debugProcess", "Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;)V", "list", "Lcom/jetbrains/javascript/debugger/sourcemap/PreloadedSourceMapList;", "collect", "mappings", "Lcom/google/common/collect/BiMap;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "processScript", "", "baseUrl", "Lcom/intellij/util/Url;", "file", "Ljava/io/File;", "resolveSourcemaps", "dir", "url", "JavaScriptDebugger"})
final class SourceMapCollector {
    private PreloadedSourceMapList list;
    private final JavaScriptDebugProcess<?> debugProcess;

    @Nullable
    public final PreloadedSourceMapList collect(@NotNull BiMap<String, VirtualFile> mappings) {
        Intrinsics.checkParameterIsNotNull(mappings, (String)"mappings");
        for (VirtualFile file : (Set)mappings.values()) {
            File ioDir = new File(file.getPath());
            if (!ioDir.isDirectory()) continue;
            Object object = mappings.inverse().get((Object)file);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            this.resolveSourcemaps(ioDir, (String)object);
        }
        return this.list;
    }

    /*
     * WARNING - void declaration
     */
    private final void resolveSourcemaps(File dir, String url) {
        File file;
        int n;
        File[] children2;
        block12: {
            block11: {
                void $receiver$iv;
                children2 = dir.listFiles(resolveSourcemaps.children.1.INSTANCE);
                if (children2 == null) break block11;
                Object[] objectArray = children2;
                if (!(((void)$receiver$iv).length == 0)) break block12;
            }
            return;
        }
        Url baseUrl = Urls.newFromIdea((CharSequence)url);
        Url baseLocalFsUrl = Urls.newLocalFileUrl((String)dir.getAbsolutePath());
        THashSet scriptsWithSourceMaps = new THashSet();
        for (n = 0; n < children2.length; ++n) {
            file = children2[n];
            String fileName = file.getName();
            if (!StringsKt.endsWith$default((String)fileName, (String)".js.map", (boolean)false, (int)2, null)) continue;
            try {
                CharSequence charSequence = SourceMapLoaderKt.loadFile(file);
                Url url2 = baseLocalFsUrl;
                Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"baseLocalFsUrl");
                SourceMap map = JavaScriptDebugProcess.decodeSourceMap$default(this.debugProcess, charSequence, url2, false, null, 8, null);
                if (map == null) continue;
                String string = map.getOutFile();
                if (string == null) {
                    void endIndex$iv;
                    void startIndex$iv;
                    void $receiver$iv;
                    String string2 = fileName;
                    boolean bl = false;
                    int n2 = fileName.length() - ".map".length();
                    void v3 = $receiver$iv;
                    if (v3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = ((String)v3).substring((int)startIndex$iv, (int)endIndex$iv);
                    string = string3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                }
                String scriptFileName = string;
                scriptsWithSourceMaps.add((Object)file);
                Url url3 = baseUrl;
                Intrinsics.checkExpressionValueIsNotNull((Object)url3, (String)"baseUrl");
                UrlImpl scriptUrl = SourceMapCollectorKt.access$createUrl(url3, scriptFileName);
                Url url4 = baseUrl;
                Intrinsics.checkExpressionValueIsNotNull((Object)url4, (String)"baseUrl");
                CharSequence charSequence2 = fileName;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence2, (String)"fileName");
                if (this.list.add((Url)SourceMapCollectorKt.access$createUrl(url4, charSequence2), map, (Url)scriptUrl)) continue;
                JavaScriptDebugProcessKt.getLOG().warn("map for " + scriptUrl + " is already preloaded");
                continue;
            }
            catch (Exception e) {
                JavaScriptDebugProcessKt.getLOG().error((Throwable)e);
            }
        }
        for (n = 0; n < children2.length; ++n) {
            file = children2[n];
            if (scriptsWithSourceMaps.contains((Object)file)) continue;
            try {
                Url url5 = baseUrl;
                Intrinsics.checkExpressionValueIsNotNull((Object)url5, (String)"baseUrl");
                File file2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                this.processScript(url5, file2);
                continue;
            }
            catch (IOException e) {
                JavaScriptDebugProcessKt.getLOG().error((Throwable)e);
            }
        }
    }

    private final void processScript(Url baseUrl, File file) {
        String sourceMapUrl = SourceMapLoaderKt.getSourceMapUrl(file);
        if (sourceMapUrl != null && URLUtil.isDataUri((String)sourceMapUrl)) {
            CharSequence charSequence = file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"file.name");
            UrlImpl scriptUrl = SourceMapCollectorKt.access$createUrl(baseUrl, charSequence);
            CharSequence charSequence2 = SourceMapLoaderKt.loadFromDataUri(sourceMapUrl, (Url)scriptUrl, this.debugProcess.getSession());
            if (charSequence2 == null) {
                return;
            }
            CharSequence data = charSequence2;
            SourceMap map = this.debugProcess.decodeSourceMap(data, baseUrl, false, null);
            if (map != null) {
                this.list.add((Url)scriptUrl, map, (Url)scriptUrl);
            }
        }
    }

    public SourceMapCollector(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        this.debugProcess = debugProcess;
        this.list = this.debugProcess.getPreloadedSourceMaps$JavaScriptDebugger();
    }
}

