/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.sourcemap;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcessKt;
import com.jetbrains.javascript.debugger.JsFileUtil;
import com.jetbrains.javascript.debugger.sourcemap.PreloadedSourceMapList;
import com.jetbrains.javascript.debugger.sourcemap.SourceMapLoaderKt;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.StaticFileHandlerKt;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.WebServerFileHandlerKt;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.io.NettyKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/javascript/debugger/sourcemap/SourceMapDetectorFileHandler;", "Lorg/jetbrains/builtInWebServer/WebServerFileHandler;", "()V", "process", "", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "canonicalPath", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "channel", "Lio/netty/channel/Channel;", "projectNameIfNotCustomHost", "", "JavaScriptDebugger"})
final class SourceMapDetectorFileHandler
extends WebServerFileHandler {
    public boolean process(@NotNull PathInfo pathInfo, @NotNull CharSequence canonicalPath, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull Channel channel, @Nullable String projectNameIfNotCustomHost) {
        int startIndex$iv;
        String $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)pathInfo, (String)"pathInfo");
        Intrinsics.checkParameterIsNotNull((Object)canonicalPath, (String)"canonicalPath");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        File file = pathInfo.getIoFile();
        if (file == null || !StringsKt.endsWith((String)file.getName(), (String)".js", (boolean)true)) {
            return false;
        }
        List debugProcesses = XDebuggerManager.getInstance((Project)project).getDebugProcesses(JavaScriptDebugProcess.class);
        if (debugProcesses.isEmpty()) {
            return false;
        }
        String string = SourceMapLoaderKt.getSourceMapUrl(file);
        if (string == null) {
            return false;
        }
        String sourceMapUrl = string;
        Url scriptUrl = Urls.newUrl((String)NettyKt.getUriScheme((Channel)channel), (String)NettyKt.getHost((HttpRequest)((HttpRequest)request)), (String)WebServerFileHandlerKt.getRequestPath((CharSequence)canonicalPath, (String)projectNameIfNotCustomHost));
        Url parsedUrl = SourceMapLoaderKt.canonicalizeUrl(sourceMapUrl, scriptUrl);
        if (!JsFileUtil.isOnBuiltInWebServer(parsedUrl)) {
            return false;
        }
        String path = parsedUrl.getPath();
        if (projectNameIfNotCustomHost == null) {
            String string2 = path;
            boolean bl = true;
            void v1 = $receiver$iv;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = ((String)v1).substring(startIndex$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            path = string3;
        } else if (path.length() > projectNameIfNotCustomHost.length() + 1 && StringsKt.startsWith$default((String)path, (String)projectNameIfNotCustomHost, (int)1, (boolean)false, (int)4, null) && path.charAt(projectNameIfNotCustomHost.length() + 1) == '/') {
            $receiver$iv = path;
            startIndex$iv = projectNameIfNotCustomHost.length() + 1;
            String string4 = $receiver$iv;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(startIndex$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            path = string5;
        } else {
            Logger $receiver$iv2 = JavaScriptDebugProcessKt.getLOG();
            if ($receiver$iv2.isDebugEnabled()) {
                Logger logger = $receiver$iv2;
                String string6 = "SourceMap " + parsedUrl + " doesn't belong to current project " + projectNameIfNotCustomHost;
                logger.debug(string6);
            }
            return false;
        }
        WebServerPathToFileManager webServerPathToFileManager = WebServerPathToFileManager.Companion.getInstance(project);
        String string7 = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"path");
        Object object = WebServerPathToFileManager.getPathInfo$default((WebServerPathToFileManager)webServerPathToFileManager, (String)string7, (boolean)false, (int)2, null);
        if (object == null || (object = object.getIoFile()) == null) {
            return false;
        }
        Object sourceMapFile = object;
        CharSequence sourceMapData = SourceMapLoaderKt.loadFile((File)sourceMapFile);
        SmartList promises = new SmartList();
        for (JavaScriptDebugProcess debugProcess : debugProcesses) {
            SourceMap sourceMap;
            if (debugProcess.isFilesOnlyInLocalFileSystem()) continue;
            PreloadedSourceMapList preloadedSourceMapList = debugProcess.getPreloadedSourceMaps$JavaScriptDebugger();
            Url url = scriptUrl;
            Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"scriptUrl");
            if (preloadedSourceMapList.containsScript(url)) continue;
            Url url2 = scriptUrl;
            Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"scriptUrl");
            if (JavaScriptDebugProcess.decodeSourceMap$default(debugProcess, sourceMapData, url2, true, null, 8, null) == null) {
                continue;
            }
            PreloadedSourceMapList preloadedSourceMapList2 = debugProcess.getPreloadedSourceMaps$JavaScriptDebugger();
            Url url3 = scriptUrl;
            Intrinsics.checkExpressionValueIsNotNull((Object)url3, (String)"scriptUrl");
            if (!preloadedSourceMapList2.add(parsedUrl, sourceMap, url3)) continue;
            debugProcess.sourceMapFound(sourceMap, null, scriptUrl, (List)promises);
        }
        Promise promise2 = Promise.all((Collection)((Collection)promises));
        if (promise2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.Promise<kotlin.Any>");
        }
        promise2.processed(new Consumer<? super T>(channel, file, request){
            final /* synthetic */ Channel $channel;
            final /* synthetic */ File $file;
            final /* synthetic */ FullHttpRequest $request;

            public final void consume(Object it) {
                StaticFileHandlerKt.sendIoFile((Channel)this.$channel, (File)this.$file, (HttpRequest)((HttpRequest)this.$request));
            }
            {
                this.$channel = channel;
                this.$file = file;
                this.$request = fullHttpRequest;
            }
        });
        return true;
    }
}

