/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.sourcemap;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Base64;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.URLUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.javascript.debugger.sourcemap.SourceMapLoaderKt;
import io.netty.util.CharsetUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Request;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceResolverKt;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.io.LocalFileFinder;
import org.jetbrains.rpc.CommandProcessorKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\b\u0010\t\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u0013\u001a\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00012\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0018\u001a\u00020\u0001H\u0000\u001a\"\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u001a\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001f\u001a\u00020\u0007\u001a\u0010\u0010 \u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\u0013\u001a\n\u0010!\u001a\u00020\u0015*\u00020\u0012\u001a\n\u0010!\u001a\u00020\u0015*\u00020\u0013\u001a\u0014\u0010!\u001a\u00020\u0015*\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"REFERENCE_LINE", "", "REFERENCE_PATTERN_FILE", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "REFERENCE_PATTERN_LINE", "canonicalizeUrl", "Lcom/intellij/util/Url;", "url", "baseUrl", "decodeString", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "charBuffer", "Ljava/nio/CharBuffer;", "getSourceMapUrl", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/io/File;", "string", "", "pattern", "getStringFromDataUri", "dataUrl", "loadFromDataUri", "sourceMapUrl", "baseFileUrl", "session", "Lcom/intellij/xdebugger/XDebugSession;", "loadSourceMapData", "parsedUrl", "tail", "loadFile", "Ljava/io/InputStreamReader;", "length", "", "JavaScriptDebugger"})
public final class SourceMapLoaderKt {
    private static final String REFERENCE_LINE = "//(?:@|#)[ \\t]sourceMappingURL=[ \\t]*(?:file://)?([^\\r\\n]*)\\s*(?:\\*/\\s*)?$";
    private static final Pattern REFERENCE_PATTERN_FILE;
    private static final Pattern REFERENCE_PATTERN_LINE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final CharSequence loadSourceMapData(@NotNull Url parsedUrl) {
        void $receiver$iv;
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)parsedUrl, (String)"parsedUrl");
        if (parsedUrl.isInLocalFileSystem()) {
            try {
                VirtualFile virtualFile = LocalFileFinder.findFile((String)parsedUrl.getPath());
                if (virtualFile == null) return null;
                CharSequence charSequence2 = SourceMapLoaderKt.loadFile(virtualFile);
                return charSequence2;
            }
            catch (IOException e) {
                CommandProcessorKt.getLOG().info((Throwable)e);
            }
        } else if (!Intrinsics.areEqual((Object)parsedUrl.getScheme(), (Object)"http") && !Intrinsics.areEqual((Object)parsedUrl.getScheme(), (Object)"https")) {
            CommandProcessorKt.getLOG().warn("Cannot load source map from '" + parsedUrl + "': scheme " + parsedUrl.getScheme() + " is not supported");
            return null;
        }
        long start = System.nanoTime();
        String url = parsedUrl.toExternalForm();
        try {
            charSequence = (CharSequence)Request.Get((String)url).connectTimeout(HttpConfigurable.CONNECTION_TIMEOUT).socketTimeout(HttpConfigurable.READ_TIMEOUT).execute().handleResponse((ResponseHandler)loadSourceMapData.1.INSTANCE);
        }
        catch (Exception e222) {
            void $receiver$iv2;
            try {
                CommandProcessorKt.getLOG().error((Throwable)e222);
            }
            catch (Throwable throwable) {
                void $receiver$iv3;
                Logger $i$a$2 = CommandProcessorKt.getLOG();
                if (!$receiver$iv3.isDebugEnabled()) throw throwable;
                void var8_12 = $receiver$iv3;
                String string = String.format("Load " + url + " took %d ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(\u2026stem.nanoTime() - start))");
                String string2 = string;
                var8_12.debug(string2);
                throw throwable;
            }
            Logger e222 = CommandProcessorKt.getLOG();
            if (!$receiver$iv2.isDebugEnabled()) return null;
            void var8_11 = $receiver$iv2;
            String string = String.format("Load " + url + " took %d ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(\u2026stem.nanoTime() - start))");
            String string3 = string;
            var8_11.debug(string3);
            return null;
        }
        Logger logger = CommandProcessorKt.getLOG();
        if (!$receiver$iv.isDebugEnabled()) return charSequence;
        void var8_10 = $receiver$iv;
        String string = String.format("Load " + url + " took %d ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(\u2026stem.nanoTime() - start))");
        String string4 = string;
        var8_10.debug(string4);
        return charSequence;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String getStringFromDataUri(@NotNull String dataUrl) {
        Intrinsics.checkParameterIsNotNull((Object)dataUrl, (String)"dataUrl");
        Matcher matcher = URLUtil.DATA_URI_PATTERN.matcher(StringUtil.unquoteString((String)dataUrl));
        if (matcher.matches()) {
            try {
                String string;
                String content = matcher.group(4);
                if (StringsKt.equals((String)";base64", (String)matcher.group(3), (boolean)true)) {
                    void charset$iv;
                    void $receiver$iv;
                    byte[] byArray = Base64.decode((String)content);
                    Charset charset = Charsets.UTF_8;
                    string = new String((byte[])$receiver$iv, (Charset)charset$iv);
                } else {
                    void e;
                    string = e;
                }
                return string;
            }
            catch (IllegalArgumentException e) {
                CommandProcessorKt.getLOG().warn((Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final CharSequence loadFromDataUri(@NotNull String sourceMapUrl, @NotNull Url baseFileUrl, @Nullable XDebugSession session) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)sourceMapUrl, (String)"sourceMapUrl");
        Intrinsics.checkParameterIsNotNull((Object)baseFileUrl, (String)"baseFileUrl");
        String sourceMapData = SourceMapLoaderKt.getStringFromDataUri(sourceMapUrl);
        if (sourceMapData == null) {
            Unit unit;
            String message = "Cannot decode sourcemap data URI " + baseFileUrl;
            XDebugSession xDebugSession = session;
            if (xDebugSession != null) {
                xDebugSession.reportError(message);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            CommandProcessorKt.getLOG().error(message);
            return null;
        }
        CharSequence message = sourceMapData;
        return $receiver$iv.length() == 0 ? (CharSequence)null : (CharSequence)sourceMapData;
    }

    @NotNull
    public static final Url canonicalizeUrl(@NotNull String url, @Nullable Url baseUrl) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        if (baseUrl == null || StringsKt.contains$default((CharSequence)url, (CharSequence)"://", (boolean)false, (int)2, null)) {
            Url url2 = Urls.newFromEncoded((String)url);
            Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"Urls.newFromEncoded(url)");
            return url2;
        }
        return SourceResolverKt.doCanonicalize((String)url, (Url)baseUrl, (boolean)true, (boolean)false);
    }

    @NotNull
    public static final CharSequence loadFile(VirtualFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return SourceMapLoaderKt.loadFile(new InputStreamReader($receiver.getInputStream(), $receiver.getCharset()), (int)$receiver.getLength());
    }

    @NotNull
    public static final CharSequence loadFile(File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        File $receiver$iv = $receiver;
        InputStream inputStream = new FileInputStream($receiver$iv);
        Charset charset = null;
        boolean bl = true;
        Object var4_4 = null;
        if (var4_4 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reader");
        }
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        return SourceMapLoaderKt.loadFile(new InputStreamReader(inputStream, charset), (int)$receiver.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final CharSequence loadFile(InputStreamReader $receiver, int length) {
        Closeable $receiver$iv = $receiver;
        boolean closed$iv = false;
        try {
            int count;
            int n;
            InputStreamReader it = (InputStreamReader)$receiver$iv;
            char[] chars = new char[length];
            for (count = 0; count < chars.length && (n = $receiver.read(chars, count, chars.length - count)) > 0; count += n) {
            }
            CharSequence charSequence = (CharSequence)new JsonReaderEx.CharSequenceBackedByChars(chars, 0, count);
            return charSequence;
        }
        catch (Exception e$iv) {
            closed$iv = true;
            try {
                $receiver$iv.close();
            }
            catch (Exception closeException$iv) {
                // empty catch block
            }
            throw (Throwable)e$iv;
        }
        finally {
            if (!closed$iv) {
                $receiver$iv.close();
            }
        }
    }

    @Nullable
    public static final String getSourceMapUrl(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        try {
            if (file.isInLocalFileSystem()) {
                return SourceMapLoaderKt.getSourceMapUrl(new File(file.getPath()));
            }
            CharSequence charSequence = SourceMapLoaderKt.loadFile(file);
            Pattern pattern = REFERENCE_PATTERN_FILE;
            Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"REFERENCE_PATTERN_FILE");
            return SourceMapLoaderKt.getSourceMapUrl(charSequence, pattern);
        }
        catch (IOException e) {
            CommandProcessorKt.getLOG().error((Throwable)e);
            return null;
        }
    }

    @Nullable
    public static final String getSourceMapUrl(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        CharSequence charSequence = SourceMapLoaderKt.tail(file);
        Pattern pattern = REFERENCE_PATTERN_LINE;
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"REFERENCE_PATTERN_LINE");
        return SourceMapLoaderKt.getSourceMapUrl(charSequence, pattern);
    }

    private static final String getSourceMapUrl(CharSequence string, Pattern pattern) {
        if (string == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(string);
        return matcher.find() ? matcher.group(1) : (String)null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public static final CharSequence tail(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        length = (int)file.length();
        var2_2 = new Ref.IntRef();
        var2_2.element = Math.min(4096, length);
        $receiver$iv = new FileInputStream(file);
        closed$iv = false;
        try {
            it = (FileInputStream)$receiver$iv;
            trim = true;
            stringBuilder = null;
            charBuffer = null;
            channel = it.getChannel();
            buffer = ByteBuffer.allocate(bufferSize.element);
            position = length - bufferSize.element;
            while (position >= 0) {
                block22: {
                    channel.position(position);
                    for (count = 0; count < bufferSize.element && (n = channel.read(buffer)) > 0; count += n) {
                    }
                    v0 = RangesKt.downTo((int)(buffer.position() - 1), (int)0);
                    n = v0.getFirst();
                    var14_15 = v0.getLast();
                    var15_16 = v0.getStep();
                    v1 = n;
                    v2 = var14_15;
                    if (!(var15_16 > 0 ? v1 <= v2 : v1 >= v2)) break block22;
                    while (true) {
                        c = (char)buffer.get((int)p);
                        if (!trim) ** GOTO lbl37
                        if (c == '\n' || c == '\r') {
                            buffer.limit((int)p);
                        } else {
                            trim = false;
lbl37:
                            // 2 sources

                            if (c == '\n') {
                                buffer.position((int)(p + true));
                                if (charBuffer == null) {
                                    charBuffer = CharBuffer.allocate(buffer.remaining());
                                }
                                v3 = buffer;
                                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"buffer");
                                v4 = charBuffer;
                                if (v4 == null) {
                                    Intrinsics.throwNpe();
                                }
                                SourceMapLoaderKt.decodeString(v3, v4);
                                var20_18 = stringBuilder == null ? (CharSequence)charBuffer : (CharSequence)stringBuilder.insert(0, charBuffer);
                                return var20_18;
                            }
                        }
                        if (p == var14_15) break;
                        p += var15_16;
                    }
                }
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(bufferSize.element * 2);
                }
                if (charBuffer == null) {
                    charBuffer = CharBuffer.allocate(bufferSize.element);
                }
                buffer.position(0);
                v5 = buffer;
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"buffer");
                v6 = charBuffer;
                if (v6 == null) {
                    Intrinsics.throwNpe();
                }
                SourceMapLoaderKt.decodeString(v5, v6);
                stringBuilder.insert(0, charBuffer);
                buffer.clear();
                charBuffer.clear();
                if (position == 0) break;
                if (position < bufferSize.element) {
                    bufferSize.element = position;
                    buffer.limit(position);
                    position = 0;
                    continue;
                }
                position -= bufferSize.element;
            }
            var18_19 = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            closed$iv = true;
            try {
                $receiver$iv.close();
            }
            catch (Exception closeException$iv) {
                // empty catch block
            }
            throw (Throwable)e$iv;
        }
        finally {
            if (!closed$iv) {
                $receiver$iv.close();
            }
        }
        return null;
    }

    private static final void decodeString(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CharsetDecoder decoder = CharsetUtil.getDecoder((Charset)CharsetToolkit.UTF8_CHARSET);
        CoderResult coderResult = decoder.decode(byteBuffer, charBuffer, true);
        if (!coderResult.isUnderflow()) {
            coderResult.throwException();
        }
        if (!(coderResult = decoder.flush(charBuffer)).isUnderflow()) {
            coderResult.throwException();
        }
        charBuffer.flip();
    }

    static {
        REFERENCE_LINE = REFERENCE_LINE;
        REFERENCE_PATTERN_FILE = Pattern.compile("[" + "\\" + "r" + "\\" + "n]" + REFERENCE_LINE);
        REFERENCE_PATTERN_LINE = Pattern.compile(REFERENCE_LINE);
    }

    @NotNull
    public static final /* synthetic */ CharSequence access$loadFile(InputStreamReader $receiver, int length) {
        return SourceMapLoaderKt.loadFile($receiver, length);
    }
}

