/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.sourcemap.visualizer;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionAdapter;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.SingleAlarm;
import com.intellij.util.Url;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.JsFileUtil;
import com.jetbrains.javascript.debugger.scripts.Scripts;
import com.jetbrains.javascript.debugger.sourcemap.visualizer.SourceMapVisualizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jdesktop.swingx.combobox.ListComboBoxModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.io.LocalFileFinder;

public class SourceMapInspector {
    private static final Key<Boolean> EDITOR_MARKED = Key.create((String)"marked");
    public final EditorEx generatedEditor;
    TextEditor generatedTextEditor;
    private JPanel rightPanel;
    private final SourceMap map;
    @NotNull
    private final Disposable disposable;
    private final Project project;
    private final SingleAlarm alarm;
    private LogicalPosition positionToSelect;
    private boolean positionToSelectIsSource;
    private ListComboBoxModel<EditorListItem> editorListModel;
    private final MultiMap<MarkupModel, RangeHighlighter> currentHighlighters;
    private final SourceFileFinder sourceFileFinder;

    public SourceMapInspector(@NotNull SourceMap map, @NotNull VirtualFile generatedFile, @NotNull Project project, @NotNull Disposable disposable, @Nullable SourceFileFinder sourceFileFinder) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapInspector", "<init>"));
        }
        if (generatedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generatedFile", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapInspector", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapInspector", "<init>"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapInspector", "<init>"));
        }
        this.currentHighlighters = MultiMap.createSmart();
        this.map = map;
        this.disposable = disposable;
        this.project = project;
        this.sourceFileFinder = sourceFileFinder == null ? new SourceFileFinderImpl() : sourceFileFinder;
        this.generatedTextEditor = (TextEditor)TextEditorProvider.getInstance().createEditor(project, generatedFile);
        Disposer.register((Disposable)disposable, (Disposable)this.generatedTextEditor);
        this.generatedEditor = (EditorEx)this.generatedTextEditor.getEditor();
        SourceMapInspector.setupEditor(this.generatedEditor);
        this.generatedEditor.setHeaderComponent((JComponent)new JLabel("0:0", 4));
        SourceMapVisualizer.addMarkersToGeneratedFile(map, (MarkupModel)this.generatedEditor.getMarkupModel());
        this.alarm = new SingleAlarm(new Runnable(){

            @Override
            public void run() {
                LogicalPosition p = SourceMapInspector.this.positionToSelect;
                if (p != null) {
                    SourceMapInspector.this.positionToSelect = null;
                    if (SourceMapInspector.this.positionToSelectIsSource) {
                        SourceMapInspector.this.highlightGenerated(p);
                    } else {
                        SourceMapInspector.this.highlightSource(p);
                    }
                }
            }
        }, 100);
        this.generatedEditor.addEditorMouseMotionListener((EditorMouseMotionListener)new EditorMouseMotionAdapter(){

            public void mouseMoved(EditorMouseEvent event) {
                if (event.getMouseEvent().isShiftDown()) {
                    SourceMapInspector.this.scheduleHighlight(event.getEditor().xyToLogicalPosition(event.getMouseEvent().getPoint()), false);
                }
            }
        });
        this.generatedEditor.getCaretModel().addCaretListener((CaretListener)new CaretAdapter(){

            public void caretPositionChanged(CaretEvent event) {
                SourceMapInspector.this.scheduleHighlight(event.getNewPosition(), false);
            }
        });
    }

    private void scheduleHighlight(@NotNull LogicalPosition position, boolean positionToSelectIsSource) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapInspector", "scheduleHighlight"));
        }
        this.positionToSelect = position;
        this.positionToSelectIsSource = positionToSelectIsSource;
        this.alarm.cancelAndRequest();
    }

    public static VirtualFile getSourceFile(@NotNull Url source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapInspector", "getSourceFile"));
        }
        return LocalFileFinder.findFile((String)source.getPath());
    }

    public static String getFileTitle(VirtualFile file) {
        return JsFileUtil.trimTitle(FileUtil.getLocationRelativeToUserHome((String)file.getPresentableUrl()));
    }

    public static VirtualFile createSourceFromProvidedContent(@NotNull SourceMap map, @NotNull Url url, @NotNull UserDataHolder script) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapInspector", "createSourceFromProvidedContent"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapInspector", "createSourceFromProvidedContent"));
        }
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapInspector", "createSourceFromProvidedContent"));
        }
        int sourceIndex = map.getSourceResolver().getSourceIndex(url);
        String content = map.getSourceResolver().getSourceContent(sourceIndex);
        return content == null ? null : Scripts.createFile(url, script, content, sourceIndex);
    }

    @NotNull
    public JComponent createMainComponent(@Nullable Url selectedSourceUrl) {
        EditorListItem[] editors = new EditorListItem[this.map.getSources().length];
        Url[] sources = this.map.getSources();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.project).getFileIndex();
        int selectedIndex = -1;
        for (int i = 0; i < sources.length; ++i) {
            Url url = sources[i];
            VirtualFile file = this.sourceFileFinder.find(url);
            Font font = file == null ? UIUtil.getListFont().deriveFont(2) : (!fileIndex.isInContent(file) || fileIndex.isInLibrarySource(file) || fileIndex.isInLibraryClasses(file) ? UIUtil.getListFont() : UIUtil.getListFont().deriveFont(1));
            editors[i] = new EditorListItem(i, file, font, file == null ? url.toDecodedForm() : SourceMapInspector.getFileTitle(file));
            if (selectedIndex != -1 || selectedSourceUrl == null || !selectedSourceUrl.equals(url)) continue;
            selectedIndex = i;
        }
        this.editorListModel = new ListComboBoxModel(Arrays.asList(editors));
        ComboBox comboBox = new ComboBox(this.editorListModel, 100);
        new ComboboxSpeedSearch((JComboBox)comboBox){

            protected String getElementText(Object element) {
                EditorListItem item = (EditorListItem)element;
                return item.file == null ? item.name : item.file.getName();
            }
        };
        comboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<EditorListItem>(){

            public void customize(JList list, @Nullable EditorListItem item, int index, boolean selected, boolean hasFocus) {
                if (item != null) {
                    this.setIcon(item.file == null ? UnknownFileType.INSTANCE.getIcon() : item.file.getFileType().getIcon());
                    this.setText(item.name);
                    this.setFont(item.font);
                }
            }
        });
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LogicalPosition sourcePosition2;
                if (e.getStateChange() != 1) {
                    return;
                }
                EditorListItem selectedItem = (EditorListItem)e.getItem();
                if (selectedItem == null) {
                    return;
                }
                if (SourceMapInspector.this.rightPanel.getComponentCount() > 1) {
                    SourceMapInspector.this.rightPanel.remove(1);
                }
                if (selectedItem.editor == null && selectedItem.file != null) {
                    selectedItem.editor = SourceMapInspector.this.createSourceEditor(selectedItem.file);
                }
                if (selectedItem.editor != null) {
                    SourceMapInspector.this.rightPanel.add(selectedItem.editor.getComponent(), "Center", 1);
                }
                if (selectedItem.file == null) {
                    sourcePosition2 = new LogicalPosition(0, 0);
                } else {
                    JavaScriptDebugAware debugAware;
                    PsiFile file = PsiManager.getInstance((Project)SourceMapInspector.this.project).findFile(selectedItem.file);
                    assert (file != null);
                    PsiElement navigationElement = null;
                    JavaScriptDebugAware[] javaScriptDebugAwareArray = (JavaScriptDebugAware[])JavaScriptDebugAware.EP_NAME.getExtensions();
                    int n = javaScriptDebugAwareArray.length;
                    for (int i = 0; i < n && (navigationElement = (debugAware = javaScriptDebugAwareArray[i]).getNavigationElementForSourcemapInspector(file)) == null; ++i) {
                    }
                    if (navigationElement == null) {
                        navigationElement = file.getNavigationElement();
                    }
                    int offset = navigationElement.getTextOffset();
                    DocumentEx document = selectedItem.editor.getDocument();
                    int line = document.getLineNumber(offset);
                    sourcePosition2 = new LogicalPosition(line, offset - document.getLineStartOffset(line));
                }
                if (SourceMapInspector.this.rightPanel.getParent() != null) {
                    SourceMapInspector.this.rightPanel.revalidate();
                    SourceMapInspector.this.rightPanel.repaint();
                    SourceMapInspector.this.highlightGenerated(sourcePosition2);
                } else {
                    SourceMapInspector.this.positionToSelect = sourcePosition2;
                    SourceMapInspector.this.positionToSelectIsSource = true;
                }
            }
        });
        this.rightPanel = new JPanel(new BorderLayout());
        this.rightPanel.add((Component)comboBox, "First");
        comboBox.setSelectedIndex(selectedIndex);
        JBSplitter splitter = new JBSplitter();
        splitter.setSplitterProportionKey("SourceMapInspector.splitter");
        splitter.setFirstComponent(this.generatedEditor.getComponent());
        splitter.setSecondComponent((JComponent)this.rightPanel);
        this.generatedEditor.getComponent().addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                SourceMapInspector.this.generatedEditor.getComponent().removeAncestorListener((AncestorListener)((Object)this));
                if (SourceMapInspector.this.positionToSelect == null) {
                    return;
                }
                SourceMapInspector.this.highlightGenerated(SourceMapInspector.this.positionToSelect);
                SourceMapInspector.this.positionToSelect = null;
                SourceMapInspector.this.positionToSelectIsSource = false;
            }
        });
        JBSplitter jBSplitter = splitter;
        if (jBSplitter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapInspector", "createMainComponent"));
        }
        return jBSplitter;
    }

    @NotNull
    private EditorEx createSourceEditor(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapInspector", "createSourceEditor"));
        }
        TextEditor textEditor = (TextEditor)TextEditorProvider.getInstance().createEditor(this.project, virtualFile);
        EditorEx sourceEditor = (EditorEx)textEditor.getEditor();
        SourceMapInspector.setupEditor(sourceEditor);
        sourceEditor.getCaretModel().addCaretListener((CaretListener)new CaretAdapter(){

            public void caretPositionChanged(CaretEvent event) {
                SourceMapInspector.this.scheduleHighlight(event.getNewPosition(), true);
            }
        });
        Disposer.register((Disposable)this.disposable, (Disposable)textEditor);
        EditorEx editorEx = sourceEditor;
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapInspector", "createSourceEditor"));
        }
        return editorEx;
    }

    private static void setupEditor(@NotNull EditorEx editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapInspector", "setupEditor"));
        }
        editor.setRendererMode(true);
        editor.getSettings().setLineNumbersShown(true);
        XDebuggerUtil.getInstance().disableValueLookup((Editor)editor);
    }

    private void highlightGenerated(@NotNull LogicalPosition sourcePosition2) {
        VirtualFile sourceFile;
        if (sourcePosition2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcePosition", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapInspector", "highlightGenerated"));
        }
        this.removeHighlighters();
        EditorListItem item = (EditorListItem)this.editorListModel.getSelectedItem();
        VirtualFile virtualFile = sourceFile = item == null ? null : item.file;
        if (sourceFile == null) {
            return;
        }
        MappingList mappingsOrderedBySource = this.map.getMappingsOrderedBySource(item.sourceIndex);
        int mappingIndex = mappingsOrderedBySource.indexOf(sourcePosition2.line, sourcePosition2.column);
        if (mappingIndex == -1) {
            return;
        }
        final MappingEntry mapping = mappingsOrderedBySource.get(sourcePosition2.line, sourcePosition2.column);
        assert (mapping != null);
        this.addSelectedHighlighter((Editor)item.editor, mapping, mappingsOrderedBySource);
        final MappingEntry nextMapping = mappingsOrderedBySource.getNextOnTheSameLine(mappingIndex);
        mappingsOrderedBySource.processMappingsInLine(mapping.getSourceLine(), new MappingList.MappingsProcessorInLine(){

            public boolean process(@NotNull MappingEntry entry, @Nullable MappingEntry nextEntry) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapInspector$9", "process"));
                }
                if (entry.getSourceColumn() >= mapping.getSourceColumn()) {
                    SourceMapInspector.this.addSelectedHighlighter((Editor)SourceMapInspector.this.generatedEditor, entry, SourceMapInspector.this.map.getMappings());
                }
                return nextEntry != null && nextEntry != nextMapping;
            }
        });
        this.generatedEditor.getScrollingModel().scrollTo(new LogicalPosition(mapping.getGeneratedLine(), mapping.getGeneratedColumn()), ScrollType.CENTER);
    }

    private void removeHighlighters() {
        if (this.currentHighlighters.isEmpty()) {
            return;
        }
        for (MarkupModel markupModel : this.currentHighlighters.keySet()) {
            for (RangeHighlighter rangeHighlighter : this.currentHighlighters.get((Object)markupModel)) {
                if (!rangeHighlighter.isValid()) continue;
                markupModel.removeHighlighter(rangeHighlighter);
            }
        }
        this.currentHighlighters.clear();
    }

    private void addSelectedHighlighter(@NotNull Editor editor, @NotNull MappingEntry mapping, @NotNull MappingList mappings) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapInspector", "addSelectedHighlighter"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapInspector", "addSelectedHighlighter"));
        }
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapInspector", "addSelectedHighlighter"));
        }
        int lineStartOffset = editor.getDocument().getLineStartOffset(mappings.getLine(mapping));
        this.addSelectedHighlighter(editor.getMarkupModel(), lineStartOffset + mappings.getColumn(mapping), mappings.getEndOffset(mapping, lineStartOffset, editor.getDocument()));
    }

    private void addSelectedHighlighter(@NotNull MarkupModel markupModel, int startOffset, int endOffset) {
        if (markupModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markupModel", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapInspector", "addSelectedHighlighter"));
        }
        if (startOffset == endOffset) {
            return;
        }
        if (endOffset < startOffset) {
            throw new IllegalStateException();
        }
        RangeHighlighter highlighter = markupModel.addRangeHighlighter(startOffset, endOffset, 6100, SourceMapVisualizer.SELECTED_MARKER, HighlighterTargetArea.EXACT_RANGE);
        this.currentHighlighters.putValue((Object)markupModel, (Object)highlighter);
    }

    private void highlightSource(@NotNull LogicalPosition generatedPosition) {
        JLabel component;
        if (generatedPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generatedPosition", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapInspector", "highlightSource"));
        }
        this.removeHighlighters();
        MappingEntry mapping = this.map.getMappings().get(generatedPosition.line, generatedPosition.column);
        JComponent headerComponent = this.generatedEditor.getHeaderComponent();
        if (headerComponent instanceof JLabel) {
            component = (JLabel)headerComponent;
        } else if (headerComponent != null) {
            JPanel compoundComponent = new JPanel(new BorderLayout());
            compoundComponent.add((Component)headerComponent, "First");
            component = new JLabel("0:0", 4);
            compoundComponent.add((Component)component, "Last");
            this.generatedEditor.setHeaderComponent((JComponent)compoundComponent);
        } else {
            component = new JLabel("0:0", 4);
            this.generatedEditor.setHeaderComponent((JComponent)component);
        }
        if (mapping == null || mapping.getSource() == -1) {
            component.setText("unmapped");
            return;
        }
        component.setText(mapping.getSourceLine() + ":" + mapping.getSourceColumn() + (mapping.getName() == null ? "" : " " + mapping.getName()) + " (" + mapping.getGeneratedLine() + ":" + mapping.getGeneratedColumn() + ")");
        int sourceIndex = mapping.getSource();
        EditorListItem listItem = (EditorListItem)this.editorListModel.getElementAt(sourceIndex);
        VirtualFile sourceFile = listItem.file;
        if (sourceFile == null) {
            return;
        }
        EditorEx sourceEditor = listItem.editor;
        if (sourceEditor == null) {
            sourceEditor = this.createSourceEditor(sourceFile);
            listItem.editor = sourceEditor;
            this.rightPanel.add(sourceEditor.getComponent(), "Center", 1);
            this.rightPanel.revalidate();
            this.rightPanel.repaint();
        }
        this.editorListModel.setSelectedItem((Object)listItem);
        this.addSelectedHighlighter((Editor)sourceEditor, mapping, this.map.getMappingsOrderedBySource(sourceIndex));
        this.addSelectedHighlighter((Editor)this.generatedEditor, mapping, this.map.getMappings());
        sourceEditor.getScrollingModel().scrollTo(new LogicalPosition(mapping.getSourceLine(), mapping.getSourceColumn()), ScrollType.MAKE_VISIBLE);
        if (EDITOR_MARKED.get((UserDataHolder)sourceEditor) != Boolean.TRUE) {
            EDITOR_MARKED.set((UserDataHolder)sourceEditor, (Object)true);
            SourceMapVisualizer.addMarkersToSourceFile(this.map, (MarkupModel)sourceEditor.getMarkupModel(), this.map.getSources()[sourceIndex]);
        }
    }

    class SourceFileFinderImpl
    implements SourceFileFinder {
        private final UserDataHolder userDataHolder = new UserDataHolderBase();

        SourceFileFinderImpl() {
        }

        @Override
        @Nullable
        public VirtualFile find(@NotNull Url source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapInspector$SourceFileFinderImpl", "find"));
            }
            VirtualFile file = SourceMapInspector.createSourceFromProvidedContent(SourceMapInspector.this.map, source, this.userDataHolder);
            if (file == null) {
                file = SourceMapInspector.getSourceFile(source);
            }
            if (file == null) {
                for (JavaScriptDebugProcess debugProcess : XDebuggerManager.getInstance((Project)SourceMapInspector.this.project).getDebugProcesses(JavaScriptDebugProcess.class)) {
                    WebBrowser webBrowser = debugProcess.getSession().isStopped() ? null : debugProcess.getConnection().getBrowser();
                    if (webBrowser == null || !BrowserFamily.CHROME.equals((Object)webBrowser.getFamily())) continue;
                    return debugProcess.findFileOrAny(source);
                }
            }
            return file;
        }
    }

    public static interface SourceFileFinder {
        @Nullable
        public VirtualFile find(@NotNull Url var1);
    }

    private static class EditorListItem {
        private final int sourceIndex;
        @Nullable
        private final VirtualFile file;
        private final Font font;
        @NotNull
        private final String name;
        private EditorEx editor;

        public EditorListItem(int sourceIndex, @Nullable VirtualFile file, @NotNull Font font, @NotNull String name) {
            if (font == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapInspector$EditorListItem", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapInspector$EditorListItem", "<init>"));
            }
            this.sourceIndex = sourceIndex;
            this.file = file;
            this.font = font;
            this.name = name;
        }
    }
}

