/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.sourcemap.visualizer;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.javascript.debugger.sourcemap.visualizer.SourceMapInspector;
import com.jetbrains.javascript.debugger.sourcemap.visualizer.actions.BaseSourceMapAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.io.LocalFileFinder;

class SourcemapFileViewer
extends UserDataHolderBase
implements FileEditor {
    private final SourceMap map;
    private final JPanel mainPanel;
    private TextEditor generatedTextEditor;

    SourcemapFileViewer(final @NotNull Project project, final @NotNull VirtualFile file) {
        String fileName;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourcemapFileViewer", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourcemapFileViewer", "<init>"));
        }
        this.mainPanel = new JPanel(new BorderLayout());
        final Pair<SourceMap, Exception> result = BaseSourceMapAction.Companion.compute(file);
        this.map = (SourceMap)result.first;
        if (this.map == null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    SourcemapFileViewer.this.addEditorNotification(project, result.second == null ? "Map is empty" : "Cannot decode sourcemap", result.second == null ? AllIcons.General.Information : AllIcons.General.ExclMark);
                }
            }, project.getDisposed());
            return;
        }
        VirtualFile generatedFile = null;
        if (this.map.getOutFile() != null && (generatedFile = file.getParent().findFileByRelativePath(this.map.getOutFile())) == null) {
            generatedFile = LocalFileFinder.findFile((String)this.map.getOutFile());
        }
        if (generatedFile == null && (fileName = file.getName()).endsWith(".map")) {
            generatedFile = file.getParent().findChild(fileName.substring(0, fileName.length() - ".map".length()));
        }
        if (generatedFile == null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    final EditorNotificationPanel notificationPanel = SourcemapFileViewer.this.addEditorNotification(project, "Cannot find generated file", AllIcons.General.ExclMark);
                    notificationPanel.createActionLabel("Browse", new Runnable(){

                        @Override
                        public void run() {
                            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)JavaScriptFileType.INSTANCE);
                            descriptor.setTitle("Select Generated File");
                            FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)file.getParent(), (Consumer)new Consumer<VirtualFile>(){

                                public void consume(@NotNull VirtualFile file) {
                                    if (file == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourcemapFileViewer$2$1$1", "consume"));
                                    }
                                    FileEditorManager.getInstance((Project)project).removeTopComponent((FileEditor)SourcemapFileViewer.this, (JComponent)notificationPanel);
                                    SourcemapFileViewer.this.visualize(SourcemapFileViewer.this.map, project, file);
                                }
                            });
                        }
                    });
                }
            });
        } else {
            this.visualize(this.map, project, generatedFile);
        }
    }

    private EditorNotificationPanel addEditorNotification(@NotNull Project project, @NotNull String message, @NotNull Icon icon) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourcemapFileViewer", "addEditorNotification"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourcemapFileViewer", "addEditorNotification"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourcemapFileViewer", "addEditorNotification"));
        }
        EditorNotificationPanel notificationPanel = new EditorNotificationPanel().text(message).icon(icon);
        FileEditorManager.getInstance((Project)project).addTopComponent((FileEditor)this, (JComponent)notificationPanel);
        return notificationPanel;
    }

    private void visualize(@NotNull SourceMap map, @NotNull Project project, @NotNull VirtualFile generatedFile) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourcemapFileViewer", "visualize"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourcemapFileViewer", "visualize"));
        }
        if (generatedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generatedFile", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourcemapFileViewer", "visualize"));
        }
        SourceMapInspector mapInspector = new SourceMapInspector(map, generatedFile, project, (Disposable)this, null);
        this.mainPanel.add((Component)mapInspector.createMainComponent(null), "Center");
        this.generatedTextEditor = mapInspector.generatedTextEditor;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.mainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourcemapFileViewer", "getComponent"));
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mainPanel;
    }

    @NotNull
    public String getName() {
        if ("Visualizer" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourcemapFileViewer", "getName"));
        }
        return "Visualizer";
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourcemapFileViewer", "getState"));
        }
        Object object = this.generatedTextEditor == null ? new TextEditorState() : this.generatedTextEditor.getState(level);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourcemapFileViewer", "getState"));
        }
        return object;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourcemapFileViewer", "setState"));
        }
        if (this.generatedTextEditor != null && state instanceof TextEditorState) {
            this.generatedTextEditor.setState(state);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (SourcemapFileViewer.this.generatedTextEditor != null) {
                    SourcemapFileViewer.this.generatedTextEditor.selectNotify();
                }
            }
        });
    }

    public void deselectNotify() {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (SourcemapFileViewer.this.generatedTextEditor != null) {
                    SourcemapFileViewer.this.generatedTextEditor.deselectNotify();
                }
            }
        });
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourcemapFileViewer", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourcemapFileViewer", "removePropertyChangeListener"));
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return this.generatedTextEditor == null ? null : this.generatedTextEditor.getCurrentLocation();
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }
}

