/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.css;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.impl.util.table.CssTableGeneratorUtil;
import com.intellij.psi.css.impl.util.table.CssTableLoaderValue;
import com.intellij.psi.css.impl.util.table.XmlStringWriter;
import com.intellij.util.Function;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.javaFX.css.JavaFxCssHelper;

public class JavaFxTableGeneratorUtil {
    @NonNls
    public static final String FILE_NAME = "javafx-css.html";
    @NonNls
    public static final String OUTPUT_FILE_NAME = "javafx-css-table.xml";
    @NonNls
    public static final String OUTPUT_STYLE_CLASSES_FILE_NAME = "javafx-css-classes.xml";
    @NonNls
    public static final String OUTPUT_PSEUDO_CLASSES_FILE_NAME = "javafx-css-pclasses.xml";
    @NonNls
    public static final String BASE_PATH = "plugins/javaFX-CSS/src/";

    public static void main(String[] args) throws IOException, JDOMException {
        String packagePath = JavaFxTableGeneratorUtil.class.getCanonicalName().replace('.', '/');
        String parentPath = BASE_PATH + packagePath.substring(0, packagePath.lastIndexOf(47));
        JavaFxTableGeneratorUtil.generate(parentPath, OUTPUT_FILE_NAME, new Pass<Pair<XmlStringWriter, Element>>(){

            public void pass(Pair<XmlStringWriter, Element> pair) {
                JavaFxTableGeneratorUtil.generateTable((XmlStringWriter)pair.first, (Element)pair.second);
            }
        });
        JavaFxTableGeneratorUtil.generate(parentPath, OUTPUT_STYLE_CLASSES_FILE_NAME, new Pass<Pair<XmlStringWriter, Element>>(){

            public void pass(Pair<XmlStringWriter, Element> pair) {
                JavaFxTableGeneratorUtil.generateStyleClasses((XmlStringWriter)pair.first, (Element)pair.second);
            }
        });
        JavaFxTableGeneratorUtil.generate(parentPath, OUTPUT_PSEUDO_CLASSES_FILE_NAME, new Pass<Pair<XmlStringWriter, Element>>(){

            public void pass(Pair<XmlStringWriter, Element> pair) {
                JavaFxTableGeneratorUtil.generatePseudoClasses((XmlStringWriter)pair.first, (Element)pair.second);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generate(String parentPath, String outputFileName, Pass<Pair<XmlStringWriter, Element>> generate) throws JDOMException, IOException {
        File output = new File(parentPath, outputFileName);
        if (output.exists()) {
            output.delete();
        }
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter(new FileOutputStream(output, true));
            XmlStringWriter writer = new XmlStringWriter((Writer)osw);
            writer.printlnOpeningTag("root");
            Element htmlElement = JDOMUtil.loadDocument((File)new File(parentPath, FILE_NAME)).getRootElement();
            Element bodyElement = htmlElement.getChild("body");
            generate.pass((Object)Pair.create((Object)writer, (Object)bodyElement));
            writer.printlnClosingTag();
            writer.flush();
            osw.flush();
            osw.close();
        }
        finally {
            if (osw != null) {
                osw.close();
            }
        }
    }

    private static void generateStyleClasses(XmlStringWriter writer, Element bodyElement) {
        HashSet classes = new HashSet();
        for (Object p : bodyElement.getChildren("p")) {
            String styleClassValue;
            int colonIdx;
            String value;
            String styleClass = ((Element)p).getAttributeValue("class");
            if (!"styleclass".equals(styleClass) || (value = ((Element)p).getValue()) == null || (colonIdx = value.indexOf(":")) <= -1 || (styleClassValue = value.substring(colonIdx + 1).trim()).contains(" ") || !classes.add(styleClassValue)) continue;
            writer.println();
            writer.printFullTag("value", styleClassValue);
        }
    }

    private static void generatePseudoClasses(XmlStringWriter writer, Element bodyElement) {
        HashSet propertyNames = new HashSet();
        for (Object o : bodyElement.getChildren("table")) {
            Element tbodyElement;
            Element trTitleElement;
            Element threadElement;
            Element tableElement = (Element)o;
            String classAttr = tableElement.getAttributeValue("class");
            if (!"csspropertytable".equals(classAttr) || (threadElement = tableElement.getChild("thead")) == null || (trTitleElement = threadElement.getChild("tr")) == null) continue;
            boolean pseudoClassTable = false;
            for (Object th : trTitleElement.getChildren("th")) {
                String propertyClass = ((Element)th).getAttributeValue("class");
                if (!"propertyname".equals(propertyClass)) continue;
                pseudoClassTable = "CSS Pseudo-class".equals(((Element)th).getValue().trim());
                break;
            }
            if (!pseudoClassTable || (tbodyElement = tableElement.getChild("tbody")) == null) continue;
            for (Object tr : tbodyElement.getChildren("tr")) {
                String propertyName;
                Element trElement = (Element)tr;
                List td = trElement.getChildren("td");
                if (td.size() >= 4 || (propertyName = ((Element)td.get(0)).getValue()).startsWith("Also has all pseudo-classes") || !propertyNames.add(propertyName)) continue;
                writer.println();
                writer.printFullTag("value", propertyName);
            }
        }
    }

    private static void generateTable(XmlStringWriter writer, Element bodyElement) {
        HashSet propertyNames = new HashSet();
        for (Object o : bodyElement.getChildren("table")) {
            Element tbodyElement;
            Element tableElement = (Element)o;
            String classAttr = tableElement.getAttributeValue("class");
            if (!"csspropertytable".equals(classAttr) || (tbodyElement = tableElement.getChild("tbody")) == null) continue;
            for (Object tr : tbodyElement.getChildren("tr")) {
                String valueText;
                String propertyName;
                Element trElement = (Element)tr;
                List td = trElement.getChildren("td");
                if (td.size() < 4 || !propertyNames.add(propertyName = ((Element)td.get(0)).getValue()) || (valueText = ((Element)td.get(1)).getValue()).isEmpty()) continue;
                writer.println();
                valueText = StringUtil.unquoteString((String)valueText.trim());
                valueText = valueText.replaceAll("<", "");
                valueText = valueText.replaceAll(">", "");
                int whereIdx = valueText.indexOf("where");
                if (whereIdx >= 0) {
                    valueText = valueText.substring(0, whereIdx);
                }
                valueText = valueText.replaceAll("\\s[\\s]*", " ");
                CssTableLoaderValue value = CssTableGeneratorUtil.processValuesList((String)valueText, (boolean)true);
                CssTableGeneratorUtil.collapseEmptyGroups((CssTableLoaderValue)value);
                writer.addAttribute("name", propertyName);
                writer.printlnOpeningTag("property");
                value.write("property", writer, Function.ID, (Function)new Function<String, String>(){

                    public String fun(String key) {
                        return JavaFxCssHelper.ourStyles.containsKey(key) ? key : null;
                    }
                });
                String doc = StringUtil.escapeXml((String)((Element)td.get(3)).getValue());
                writer.printFullTag("doc", valueText + StringUtil.escapeXml((String)"<br>") + doc);
                writer.printClosingTag();
            }
        }
    }
}

