/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxClassBackedElementDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxDefaultPropertyElementDescriptor;

public class JavaFXNSDescriptor
implements XmlNSDescriptor,
Validator<XmlDocument> {
    private XmlFile myFile;

    @Nullable
    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        XmlElementDescriptor descriptor;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/jetbrains/plugins/javaFX/fxml/JavaFXNSDescriptor", "getElementDescriptor"));
        }
        String name = tag.getName();
        if (tag.getName().equals("fx:root")) {
            return new JavaFxDefaultPropertyElementDescriptor(name, tag);
        }
        XmlTag parentTag = tag.getParentTag();
        if (parentTag != null && (descriptor = parentTag.getDescriptor()) != null) {
            return descriptor.getElementDescriptor(tag, parentTag);
        }
        return new JavaFxClassBackedElementDescriptor(name, tag);
    }

    @NotNull
    public XmlElementDescriptor[] getRootElementsDescriptors(@Nullable XmlDocument document) {
        Project project;
        PsiClass paneClass;
        if (document != null && (paneClass = JavaPsiFacade.getInstance((Project)(project = document.getProject())).findClass("javafx.scene.layout.Pane", GlobalSearchScope.allScope((Project)project))) != null) {
            final ArrayList result = new ArrayList();
            ClassInheritorsSearch.search((PsiClass)paneClass, (SearchScope)paneClass.getUseScope(), (boolean)true, (boolean)true, (boolean)false).forEach((Processor)new Processor<PsiClass>(){

                public boolean process(PsiClass psiClass) {
                    result.add(new JavaFxClassBackedElementDescriptor(psiClass.getName(), psiClass));
                    return true;
                }
            });
            XmlElementDescriptor[] xmlElementDescriptorArray = result.toArray(new XmlElementDescriptor[result.size()]);
            if (xmlElementDescriptorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/JavaFXNSDescriptor", "getRootElementsDescriptors"));
            }
            return xmlElementDescriptorArray;
        }
        XmlElementDescriptor[] xmlElementDescriptorArray = new XmlElementDescriptor[]{};
        if (xmlElementDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/JavaFXNSDescriptor", "getRootElementsDescriptors"));
        }
        return xmlElementDescriptorArray;
    }

    @Nullable
    public XmlFile getDescriptorFile() {
        return this.myFile;
    }

    public PsiElement getDeclaration() {
        return this.myFile;
    }

    public String getName(PsiElement context) {
        return null;
    }

    public String getName() {
        return null;
    }

    public void init(PsiElement element) {
        XmlDocument document = (XmlDocument)element;
        this.myFile = (XmlFile)document.getContainingFile();
    }

    public Object[] getDependences() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public void validate(@NotNull XmlDocument context, @NotNull Validator.ValidationHost host) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/fxml/JavaFXNSDescriptor", "validate"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/plugins/javaFX/fxml/JavaFXNSDescriptor", "validate"));
        }
    }
}

