/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.el;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.references.PomService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.jsp.ELImplicitVariable;
import com.intellij.psi.impl.source.jsp.JspImplicitVariableImpl;
import com.intellij.psi.impl.source.jsp.el.impl.ELResolveUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.jsp.el.ELExpression;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.jsp.el.ELSelectExpression;
import com.intellij.psi.jsp.el.ELVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.el.SpringBeansAsElVariableUtil;
import com.intellij.spring.el.SpringElBeanVariable;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.webflow.el.ELVariablesCollectorContext;
import com.intellij.spring.webflow.el.WebflowImplicitVariable;
import com.intellij.spring.webflow.el.scopes.WebflowScope;
import com.intellij.spring.webflow.el.scopes.providers.WebflowScopeProvider;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.spring.webflow.model.xml.Evaluate;
import com.intellij.spring.webflow.model.xml.EvaluatesOwner;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.model.xml.Identified;
import com.intellij.spring.webflow.model.xml.Input;
import com.intellij.spring.webflow.model.xml.Set;
import com.intellij.spring.webflow.model.xml.SetsOwner;
import com.intellij.spring.webflow.model.xml.Var;
import com.intellij.spring.webflow.model.xml.ViewState;
import com.intellij.spring.webflow.model.xml.WebflowDomElement;
import com.intellij.spring.webflow.resources.WebflowBundle;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ELVariablesCollectorUtils {
    private static final List<Pair<String, String>> PREDEFINED_VARIABLES = new ArrayList<Pair<String, String>>();

    private ELVariablesCollectorUtils() {
    }

    public static List<PsiVariable> getVariables(PsiElement host, CollectType collectType, CollectScope collectScope, @Nullable String nameHint) {
        PsiFile file = host.getContainingFile();
        if (!(file instanceof XmlFile)) {
            return Collections.emptyList();
        }
        List<WebflowModel> webflowModels = ELVariablesCollectorUtils.getRelevantModels((XmlFile)file, collectScope);
        if (webflowModels.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PsiVariable> resultVars = new ArrayList<PsiVariable>(webflowModels.size() * 5 + 20);
        ELVariablesCollectorUtils.collectPredefinedVariables(file, resultVars);
        if (collectType == CollectType.INCLUDE_APPLICATION_VARIABLES) {
            ELVariablesCollectorUtils.addApplicationContextVariables(host, resultVars, nameHint);
        }
        for (WebflowModel model : webflowModels) {
            ELVariablesCollectorContext context = new ELVariablesCollectorContext(model, host, resultVars);
            ELVariablesCollectorUtils.processWebflowContextVariables(context, collectScope);
        }
        return resultVars;
    }

    private static List<WebflowModel> getRelevantModels(XmlFile host, CollectScope collectScope) {
        WebflowDomModelManager webflowDomModelManager = WebflowDomModelManager.getInstance(host.getProject());
        switch (collectScope) {
            case MODULE: {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)host);
                assert (module != null) : host;
                return webflowDomModelManager.getAllModels(module);
            }
            case VIEW: {
                return webflowDomModelManager.getModelsForView((PsiFile)host);
            }
            case LOCAL: {
                WebflowModel model = webflowDomModelManager.getWebflowModel(host);
                return ContainerUtil.createMaybeSingletonList((Object)model);
            }
        }
        throw new IllegalArgumentException("not supported " + (Object)((Object)collectScope));
    }

    private static void addApplicationContextVariables(PsiElement host, List<PsiVariable> resultVars, @Nullable String nameHint) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)host);
        if (module == null) {
            return;
        }
        if (nameHint != null) {
            for (SpringModel model : SpringManager.getInstance((Project)host.getProject()).getAllModels(module)) {
                SpringBeanPointer bean = SpringModelSearchers.findBean((CommonSpringModel)model, (String)nameHint);
                if (bean == null) continue;
                SpringElBeanVariable variable = SpringBeansAsElVariableUtil.createVariable((SpringBeanPointer)bean, (String)nameHint);
                resultVars.add((PsiVariable)variable);
                return;
            }
            return;
        }
        for (SpringModel model : SpringManager.getInstance((Project)host.getProject()).getAllModels(module)) {
            SpringBeansAsElVariableUtil.addVariables(resultVars, (CommonSpringModel)model);
        }
    }

    private static void processWebflowContextVariables(ELVariablesCollectorContext context, CollectScope collectScope) {
        ELVariablesCollectorUtils.collectEvaluateVariables(context);
        ELVariablesCollectorUtils.collectSetVariables(context);
        ELVariablesCollectorUtils.collectInputVariables(context);
        ELVariablesCollectorUtils.collectVars(context, collectScope);
        context.processScopeVariables();
    }

    private static void collectEvaluateVariables(ELVariablesCollectorContext context) {
        PsiType objectClassType = ELVariablesCollectorUtils.getObjectClassType(context.getProject());
        List<Evaluate> evaluates = ELVariablesCollectorUtils.collectEvaluates(context.getWebflowModel(), true);
        for (WebflowScopeProvider scopeProvider : context.getAcceptedProviders()) {
            for (Evaluate evaluate : evaluates) {
                PsiElement element;
                String varName = scopeProvider.getVariableName(evaluate.getResult().getStringValue());
                if (StringUtil.isEmptyOrSpaces((String)varName) || !ELVariablesCollectorUtils.isInProviderScope(scopeProvider, evaluate, context) || (element = scopeProvider.getOrCreateScopeVariable(context.getFile(), varName, (PsiElement)evaluate.getResult().getXmlAttribute())) == null) continue;
                PsiClass resultTypeClass = (PsiClass)evaluate.getResultType().getValue();
                PsiClassType psiType = resultTypeClass == null ? null : PsiTypesUtil.getClassType((PsiClass)resultTypeClass);
                ELImplicitVariable variable = ELVariablesCollectorUtils.createVariable((PsiFile)context.getFile(), objectClassType, evaluate.getExpression(), (PsiType)psiType, varName, element);
                context.addScopeVariable(scopeProvider.getScope(), variable);
            }
        }
    }

    private static void collectSetVariables(ELVariablesCollectorContext context) {
        PsiType objectClassType = ELVariablesCollectorUtils.getObjectClassType(context.getProject());
        List<Set> sets = ELVariablesCollectorUtils.collectSetters(context.getWebflowModel(), true);
        for (WebflowScopeProvider scopeProvider : context.getAcceptedProviders()) {
            for (Set set : sets) {
                PsiElement element;
                String varName = scopeProvider.getVariableName(set.getName().getStringValue());
                if (StringUtil.isEmptyOrSpaces((String)varName) || !ELVariablesCollectorUtils.isInProviderScope(scopeProvider, set, context) || (element = scopeProvider.getOrCreateScopeVariable(context.getFile(), varName, (PsiElement)set.getName().getXmlAttributeValue())) == null) continue;
                PsiClass resultTypeClass = (PsiClass)set.getType().getValue();
                PsiClassType psiType = resultTypeClass == null ? null : JavaPsiFacade.getElementFactory((Project)context.getProject()).createType(resultTypeClass);
                ELImplicitVariable variable = ELVariablesCollectorUtils.createVariable((PsiFile)context.getFile(), objectClassType, set.getValue(), (PsiType)psiType, varName, element);
                context.addScopeVariable(scopeProvider.getScope(), variable);
            }
        }
    }

    private static boolean isInProviderScope(WebflowScopeProvider scopeProvider, DomElement domElement, ELVariablesCollectorContext context) {
        java.util.Set<DomElement> scopes = scopeProvider.getScopes(context.getDomElement());
        for (DomElement scope : scopes) {
            if (!DomUtil.isAncestor((DomElement)scope, (DomElement)domElement, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private static void collectInputVariables(final ELVariablesCollectorContext context) {
        final PsiType objectClassType = ELVariablesCollectorUtils.getObjectClassType(context.getProject());
        Flow flow = context.getWebflowModel().getFlow();
        ELVariablesCollectorUtils.processFlowVariables(flow, new Processor<Flow>(){

            public boolean process(Flow flow) {
                for (Input input : flow.getInputs()) {
                    String varName = input.getName().getStringValue();
                    if (StringUtil.isEmptyOrSpaces((String)varName)) continue;
                    PsiClass resultTypeClass = (PsiClass)input.getType().getValue();
                    PsiType psiType = resultTypeClass == null ? objectClassType : JavaPsiFacade.getElementFactory((Project)context.getProject()).createType(resultTypeClass);
                    context.addScopeVariable(WebflowScope.FLOW, ELVariablesCollectorUtils.createImplicitVariable(input, varName, psiType, (PsiFile)context.getFile()));
                }
                return true;
            }
        });
    }

    private static void processFlowVariables(Flow flow, Processor<Flow> processor) {
        processor.process((Object)flow);
        for (Flow parentFlow : flow.getAllParentFlows()) {
            processor.process((Object)parentFlow);
        }
    }

    private static void collectVars(ELVariablesCollectorContext context, CollectScope collectScope) {
        PsiType objectClassType = ELVariablesCollectorUtils.getObjectClassType(context.getProject());
        for (Var var : ELVariablesCollectorUtils.getVars(context, collectScope)) {
            String varName = var.getName().getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)varName)) continue;
            PsiType psiType = (PsiType)var.getClazz().getValue();
            if (psiType == null) {
                psiType = objectClassType;
            }
            context.addScopeVariable(WebflowScope.FLOW, ELVariablesCollectorUtils.createImplicitVariable(var, varName, psiType, (PsiFile)context.getFile()));
        }
    }

    private static List<Var> getVars(ELVariablesCollectorContext context, CollectScope collectScope) {
        ViewState state;
        SmartList vars = new SmartList();
        Flow flow = context.getWebflowModel().getFlow();
        vars.addAll(flow.getVars());
        if (collectScope == CollectScope.MODULE || collectScope == CollectScope.VIEW) {
            for (ViewState state2 : flow.getViewStates()) {
                vars.addAll(state2.getVars());
            }
            return vars;
        }
        DomElement domElement = context.getDomElement();
        if (domElement != null && (state = (ViewState)domElement.getParentOfType(ViewState.class, false)) != null) {
            vars.addAll(state.getVars());
        }
        for (Flow parentFlow : flow.getAllParentFlows()) {
            vars.addAll(parentFlow.getVars());
        }
        return vars;
    }

    private static ELImplicitVariable createVariable(PsiFile file, PsiType objectClassType, GenericAttributeValue<String> expressionAttr, PsiType psiType, String varName, PsiElement element) {
        return new WebflowImplicitVariable(file, varName, objectClassType, element, expressionAttr, psiType);
    }

    public static List<Evaluate> collectEvaluates(WebflowModel webflowModel, boolean withParents) {
        SmartList evaluates = new SmartList();
        DomElementVisitor visitor = new DomElementVisitor((List)evaluates){
            final /* synthetic */ List val$evaluates;
            {
                this.val$evaluates = list;
            }

            public void visitEvaluate(Evaluate evaluate) {
                this.val$evaluates.add(evaluate);
            }

            public void visitDomElement(DomElement element) {
                if (!(element instanceof WebflowDomElement)) {
                    return;
                }
                if (element instanceof EvaluatesOwner || element instanceof ViewState || element instanceof Flow) {
                    element.acceptChildren((DomElementVisitor)this);
                }
            }
        };
        ELVariablesCollectorUtils.visitFlow(visitor, webflowModel.getFlow(), withParents);
        return evaluates;
    }

    private static void visitFlow(DomElementVisitor visitor, Flow flow, boolean withParents) {
        flow.accept(visitor);
        if (withParents) {
            for (Flow parentFlow : flow.getAllParentFlows()) {
                parentFlow.accept(visitor);
            }
        }
    }

    public static List<Set> collectSetters(WebflowModel webflowModel, boolean withParents) {
        SmartList sets = new SmartList();
        DomElementVisitor visitor = new DomElementVisitor((List)sets){
            final /* synthetic */ List val$sets;
            {
                this.val$sets = list;
            }

            public void visitSet(Set set) {
                this.val$sets.add(set);
            }

            public void visitDomElement(DomElement element) {
                if (!(element instanceof WebflowDomElement)) {
                    return;
                }
                if (element instanceof SetsOwner || element instanceof Identified || element instanceof Flow) {
                    element.acceptChildren((DomElementVisitor)this);
                }
            }
        };
        ELVariablesCollectorUtils.visitFlow(visitor, webflowModel.getFlow(), withParents);
        return sets;
    }

    @NotNull
    private static PsiType getScopeResultType(GenericAttributeValue<String> expressionAttr, PsiType type, PsiFile containingFile, final ELImplicitVariable jspImplicitVariable) {
        if (type != null) {
            PsiType psiType = type;
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/el/ELVariablesCollectorUtils", "getScopeResultType"));
            }
            return psiType;
        }
        XmlAttributeValue context = expressionAttr.getXmlAttributeValue();
        final Ref injectionType = new Ref();
        assert (context != null);
        InjectedLanguageUtil.enumerate((PsiElement)context, (PsiLanguageInjectionHost.InjectedPsiVisitor)new PsiLanguageInjectionHost.InjectedPsiVisitor(){

            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                PsiElement firstChild;
                if (injectedPsi == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/spring/webflow/el/ELVariablesCollectorUtils$4", "visit"));
                }
                if (places == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/spring/webflow/el/ELVariablesCollectorUtils$4", "visit"));
                }
                PsiElement at = injectedPsi.findElementAt(injectedPsi.getTextLength() - 1);
                ELExpressionHolder holder = (ELExpressionHolder)PsiTreeUtil.getParentOfType((PsiElement)at, ELExpressionHolder.class);
                if (holder != null && (firstChild = holder.getFirstChild()) instanceof ELExpression && !ELVariablesCollectorUtils.isSelfReference(firstChild, jspImplicitVariable)) {
                    injectionType.set((Object)ELResolveUtil.resolveContextAsType((ELExpression)((ELExpression)firstChild)));
                }
            }
        });
        PsiType contextType = (PsiType)injectionType.get();
        if (contextType != null) {
            PsiType psiType = contextType;
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/el/ELVariablesCollectorUtils", "getScopeResultType"));
            }
            return psiType;
        }
        PsiType psiType = ELVariablesCollectorUtils.getObjectClassType(containingFile.getProject());
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/el/ELVariablesCollectorUtils", "getScopeResultType"));
        }
        return psiType;
    }

    private static boolean isSelfReference(PsiElement firstChild, ELImplicitVariable jspImplicitVariable) {
        PsiReference[] references;
        ELVariable var = null;
        if (firstChild instanceof ELVariable) {
            var = (ELVariable)firstChild;
        }
        if (firstChild instanceof ELSelectExpression) {
            var = ((ELSelectExpression)firstChild).getField();
        }
        return var != null && (references = var.getReferences()).length > 0 && jspImplicitVariable.equals(references[0].resolve());
    }

    @Nullable
    public static String getVariableName(WebflowScope scope, String value) {
        if (StringUtil.isEmptyOrSpaces((String)value)) {
            return null;
        }
        String s = StringUtil.trimStart((String)value, (String)(scope.getName() + "."));
        return s.equals(value) || s.contains(".") ? null : s;
    }

    private static void collectPredefinedVariables(PsiFile scope, List<PsiVariable> vars) {
        PsiType objectClassType = ELVariablesCollectorUtils.getObjectClassType(scope.getProject());
        for (Pair<String, String> pair : PREDEFINED_VARIABLES) {
            String varName = (String)pair.first;
            String className = (String)pair.second;
            PsiType psiType = ELVariablesCollectorUtils.getPsiClassTypeByName(scope.getProject(), className);
            if (psiType == null) {
                psiType = objectClassType;
            }
            ELVariablesCollectorUtils.addImplicitVariable(null, varName, vars, psiType, scope);
        }
    }

    private static PsiType getObjectClassType(Project project) {
        return PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
    }

    @Nullable
    private static PsiType getPsiClassTypeByName(Project project, String className) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass psiClass = psiFacade.findClass(className, GlobalSearchScope.allScope((Project)project));
        return psiClass == null ? null : psiFacade.getElementFactory().createType(psiClass);
    }

    private static void addImplicitVariable(PsiElement psiElement, @Nullable String name, List<PsiVariable> result, @Nullable PsiType type, PsiFile file) {
        if (name == null || name.length() == 0 || type == null) {
            return;
        }
        result.add((PsiVariable)new JspImplicitVariableImpl((PsiElement)file, name, type, psiElement, "NESTED"){

            @Nullable
            public String getLocationString() {
                return WebflowBundle.message("el.location.name", new Object[0]);
            }
        });
    }

    private static ELImplicitVariable createImplicitVariable(WebflowDomElement element, String name, @NotNull PsiType type, PsiFile file) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/spring/webflow/el/ELVariablesCollectorUtils", "createImplicitVariable"));
        }
        assert (StringUtil.isNotEmpty((String)name));
        DomTarget target = DomTarget.getTarget((DomElement)element);
        assert (target != null);
        return new JspImplicitVariableImpl((PsiElement)file, name, type, PomService.convertToPsi((PsiTarget)target), "NESTED"){

            @Nullable
            public String getLocationString() {
                PsiFile containingFile = this.getContainingFile();
                return containingFile != null ? containingFile.getName() : null;
            }
        };
    }

    static {
        PREDEFINED_VARIABLES.add((Pair<String, String>)Pair.create((Object)"currentUser", (Object)"java.security.Principal"));
        PREDEFINED_VARIABLES.add((Pair<String, String>)Pair.create((Object)"persistenceContext", (Object)"javax.persistence.EntityManager"));
        PREDEFINED_VARIABLES.add((Pair<String, String>)Pair.create((Object)"currentEvent", (Object)"org.springframework.webflow.execution.Event"));
        PREDEFINED_VARIABLES.add((Pair<String, String>)Pair.create((Object)"messageContext", (Object)"org.springframework.binding.message.MessageContext"));
        PREDEFINED_VARIABLES.add((Pair<String, String>)Pair.create((Object)"resourceBundle", (Object)"java.util.Properties"));
        PREDEFINED_VARIABLES.add((Pair<String, String>)Pair.create((Object)"flowRequestContext", (Object)"org.springframework.webflow.execution.RequestContext"));
        PREDEFINED_VARIABLES.add((Pair<String, String>)Pair.create((Object)"flowExecutionContext", (Object)"org.springframework.webflow.execution.FlowExecutionContext"));
        PREDEFINED_VARIABLES.add((Pair<String, String>)Pair.create((Object)"flowExecutionUrl", (Object)"java.lang.String"));
        PREDEFINED_VARIABLES.add((Pair<String, String>)Pair.create((Object)"externalContext", (Object)"org.springframework.webflow.context.ExternalContext"));
    }

    public static enum CollectType {
        DEFAULT,
        INCLUDE_APPLICATION_VARIABLES;

    }

    public static enum CollectScope {
        LOCAL,
        VIEW,
        MODULE;

    }
}

