/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.el.inject;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.webflow.config.model.xml.version2_0.FlowBuilderServices;
import com.intellij.spring.webflow.el.inject.ExpressionLanguageConfiguration;
import com.intellij.spring.webflow.model.WebflowVersion;
import com.intellij.spring.webflow.util.WebflowVersionDetector;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionLanguageConfigurationDeterminer {
    private static final String JBOSS_EL_EXPRESSION_FACTORY_CLASS_NAME = "org.jboss.el.ExpressionFactoryImpl";
    private static final String OGNL_EXPRESSION_PARSER_CLASS_NAME = "org.springframework.webflow.expression.WebFlowOgnlExpressionParser";
    private final Module module;

    public static ExpressionLanguageConfigurationDeterminer getInstance(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/webflow/el/inject/ExpressionLanguageConfigurationDeterminer", "getInstance"));
        }
        return (ExpressionLanguageConfigurationDeterminer)ModuleServiceManager.getService((Module)module, ExpressionLanguageConfigurationDeterminer.class);
    }

    protected ExpressionLanguageConfigurationDeterminer(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/webflow/el/inject/ExpressionLanguageConfigurationDeterminer", "<init>"));
        }
        this.module = module;
    }

    @NotNull
    public ExpressionLanguageConfiguration determine() {
        AtomicNotNullLazyValue value = (AtomicNotNullLazyValue)CachedValuesManager.getManager((Project)this.module.getProject()).getCachedValue((UserDataHolder)this.module, (CachedValueProvider)new CachedValueProvider<AtomicNotNullLazyValue<ExpressionLanguageConfiguration>>(){

            public CachedValueProvider.Result<AtomicNotNullLazyValue<ExpressionLanguageConfiguration>> compute() {
                AtomicNotNullLazyValue<ExpressionLanguageConfiguration> value = new AtomicNotNullLazyValue<ExpressionLanguageConfiguration>(){

                    @NotNull
                    protected ExpressionLanguageConfiguration compute() {
                        ExpressionLanguageConfiguration expressionLanguageConfiguration = (ExpressionLanguageConfiguration)((Object)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ExpressionLanguageConfiguration>(){

                            public ExpressionLanguageConfiguration compute() {
                                ExpressionLanguageConfiguration configuration = ExpressionLanguageConfigurationDeterminer.this.determineBySpring();
                                if (configuration != null) {
                                    return configuration;
                                }
                                return ExpressionLanguageConfigurationDeterminer.this.determineByWebFlowVersion();
                            }
                        }));
                        if (expressionLanguageConfiguration == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/el/inject/ExpressionLanguageConfigurationDeterminer$1$1", "compute"));
                        }
                        return expressionLanguageConfiguration;
                    }
                };
                return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
        ExpressionLanguageConfiguration expressionLanguageConfiguration = (ExpressionLanguageConfiguration)((Object)value.getValue());
        if (expressionLanguageConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/el/inject/ExpressionLanguageConfigurationDeterminer", "determine"));
        }
        return expressionLanguageConfiguration;
    }

    @NotNull
    private ExpressionLanguageConfiguration determineByWebFlowVersion() {
        WebflowVersion webflowVersion = WebflowVersionDetector.detect(this.module);
        if (webflowVersion.isAtLeast(WebflowVersion.Webflow_2_1)) {
            ExpressionLanguageConfiguration expressionLanguageConfiguration = ExpressionLanguageConfiguration.SPRING_EL;
            if (expressionLanguageConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/el/inject/ExpressionLanguageConfigurationDeterminer", "determineByWebFlowVersion"));
            }
            return expressionLanguageConfiguration;
        }
        if (webflowVersion.isAtLeast(WebflowVersion.Webflow_2_0)) {
            ExpressionLanguageConfiguration expressionLanguageConfiguration = ExpressionLanguageConfiguration.EL;
            if (expressionLanguageConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/el/inject/ExpressionLanguageConfigurationDeterminer", "determineByWebFlowVersion"));
            }
            return expressionLanguageConfiguration;
        }
        ExpressionLanguageConfiguration expressionLanguageConfiguration = ExpressionLanguageConfiguration.OGNL;
        if (expressionLanguageConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/el/inject/ExpressionLanguageConfigurationDeterminer", "determineByWebFlowVersion"));
        }
        return expressionLanguageConfiguration;
    }

    @Nullable
    private ExpressionLanguageConfiguration determineBySpring() {
        Set models = SpringManager.getInstance((Project)this.module.getProject()).getAllModels(this.module);
        for (SpringModel model : models) {
            if (!(model instanceof XmlSpringModel)) continue;
            Set roots = ((XmlSpringModel)model).getLocalModelsRoots();
            for (DomFileElement domFileElement : roots) {
                if (!SpringDomUtils.hasElement((DomFileElement)domFileElement, FlowBuilderServices.class)) continue;
                List flowBuilderServices = DomUtil.getDefinedChildrenOfType((DomElement)domFileElement.getRootElement(), FlowBuilderServices.class, (boolean)true, (boolean)false);
                for (FlowBuilderServices services : flowBuilderServices) {
                    PsiClassType jBossEl;
                    List args;
                    ConstructorArg constructorArg;
                    SpringBeanPointer expressionParser = (SpringBeanPointer)services.getExpressionParser().getValue();
                    if (expressionParser == null) continue;
                    CommonSpringBean commonSpringBean = expressionParser.getSpringBean();
                    PsiClass beanClass = commonSpringBean.getBeanClass();
                    if (beanClass != null && OGNL_EXPRESSION_PARSER_CLASS_NAME.equals(beanClass.getQualifiedName())) {
                        return ExpressionLanguageConfiguration.OGNL;
                    }
                    if (!(commonSpringBean instanceof SpringBean) || (constructorArg = (ConstructorArg)ContainerUtil.getFirstItem((List)(args = ((SpringBean)commonSpringBean).getConstructorArgs()))) == null || !constructorArg.isAssignable((PsiType)(jBossEl = JavaPsiFacade.getInstance((Project)this.module.getProject()).getElementFactory().createTypeByFQClassName(JBOSS_EL_EXPRESSION_FACTORY_CLASS_NAME)))) continue;
                    return ExpressionLanguageConfiguration.EL;
                }
            }
        }
        return null;
    }
}

