/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.inspections;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.webflow.config.model.xml.version2_0.FlowExecutor;
import com.intellij.spring.webflow.config.model.xml.version2_0.FlowRegistry;
import com.intellij.spring.webflow.resources.WebflowBundle;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WebflowConfigModelInspection
extends SpringBeanInspectionBase {
    public void checkFileElement(DomFileElement<Beans> domFileElement, DomElementAnnotationHolder holder) {
        if (!SpringDomUtils.hasNamespace(domFileElement, (String)"Spring Webflow Config namespace key")) {
            return;
        }
        PsiClass flowRegistryClass = DomJavaUtil.findClass((String)"org.springframework.webflow.definition.registry.FlowDefinitionRegistry", domFileElement);
        if (flowRegistryClass == null) {
            return;
        }
        Beans beans = (Beans)domFileElement.getRootElement();
        beans.acceptChildren((DomElementVisitor)new WebflowConfigModelVisitor(holder, domFileElement.getFile(), flowRegistryClass));
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("WebflowConfigModelInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/inspections/WebflowConfigModelInspection", "getShortName"));
        }
        return "WebflowConfigModelInspection";
    }

    private static class WebflowConfigModelVisitor
    implements DomElementVisitor {
        private static final Condition<SpringBeanPointer> DEFAULT_ID_CONDITION = new Condition<SpringBeanPointer>(){

            public boolean value(SpringBeanPointer pointer) {
                CommonSpringBean bean = pointer.getSpringBean();
                if (bean instanceof FlowRegistry) {
                    return "flowRegistry".equals(pointer.getName());
                }
                return false;
            }
        };
        private final DomElementAnnotationHolder myHolder;
        private final XmlFile myFile;
        private final PsiClass myFlowRegistryClass;
        private final AtomicNotNullLazyValue<Boolean> myHasFlowRegistryWithDefaultId = new AtomicNotNullLazyValue<Boolean>(){

            @NotNull
            protected Boolean compute() {
                CommonSpringModel springModel = SpringModelUtils.getInstance().getModuleCombinedSpringModel((PsiElement)WebflowConfigModelVisitor.this.myFile);
                SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)WebflowConfigModelVisitor.this.myFlowRegistryClass).withInheritors();
                List flowRegistryBeans = SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)searchParameters);
                Boolean bl = ContainerUtil.exists((Iterable)flowRegistryBeans, (Condition)DEFAULT_ID_CONDITION);
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/inspections/WebflowConfigModelInspection$WebflowConfigModelVisitor$2", "compute"));
                }
                return bl;
            }
        };

        private WebflowConfigModelVisitor(DomElementAnnotationHolder holder, XmlFile file, PsiClass flowRegistryClass) {
            this.myHolder = holder;
            this.myFile = file;
            this.myFlowRegistryClass = flowRegistryClass;
        }

        public void visitDomElement(DomElement element) {
        }

        public void visitFlowExecutor(FlowExecutor flowExecutor) {
            if (DomUtil.hasXml(flowExecutor.getFlowRegistry())) {
                return;
            }
            if (!((Boolean)this.myHasFlowRegistryWithDefaultId.getValue()).booleanValue()) {
                this.myHolder.createProblem((DomElement)flowExecutor, HighlightSeverity.ERROR, WebflowBundle.message("webflow.model.config.inspection.no.flow.registry.with.default.id", "flowRegistry"));
            }
        }
    }
}

