/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.converters;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.webflow.model.converters.WebflowConverterUtil;
import com.intellij.spring.webflow.model.converters.WebflowLookupUtil;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.resources.WebflowBundle;
import com.intellij.spring.webflow.util.WebflowUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParentStateFlowReference
extends PsiReferenceBase<PsiElement>
implements EmptyResolveMessageProvider {
    @NotNull
    private final List<Flow> relatedFlows;
    @Nullable
    private final Flow flow;

    ParentStateFlowReference(PsiElement element, TextRange range, @NotNull GenericDomValue<String> value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/spring/webflow/model/converters/ParentStateFlowReference", "<init>"));
        }
        super(element, range, true);
        this.relatedFlows = ParentStateFlowReference.getAllRelatedFlows(value);
        this.flow = this.findFlow();
    }

    @Nullable
    public Flow getFlow() {
        return this.flow;
    }

    @Nullable
    private Flow findFlow() {
        final String flowName = this.getValue();
        return (Flow)ContainerUtil.find(this.relatedFlows, (Condition)new Condition<Flow>(){

            public boolean value(Flow flow) {
                String name = WebflowUtil.getFlowName(flow);
                return Comparing.equal((String)name, (String)flowName);
            }
        });
    }

    public PsiElement resolve() {
        if (this.getValue().isEmpty()) {
            return this.myElement;
        }
        if (this.flow == null) {
            return null;
        }
        return WebflowUtil.resolveFlow(this.flow);
    }

    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = WebflowLookupUtil.forFlows(this.relatedFlows);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/ParentStateFlowReference", "getVariants"));
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = WebflowBundle.message("parent.state.converter.can.not.resolve.flow", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/ParentStateFlowReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    public boolean isReferenceTo(PsiElement element) {
        return super.isReferenceTo(element) || WebflowConverterUtil.isCustomFlowIdReference(element);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        if (this.resolve() instanceof XmlFile) {
            String name = FileUtil.getNameWithoutExtension((String)newElementName);
            return super.handleElementRename(name);
        }
        return super.handleElementRename(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        VirtualFile file;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/webflow/model/converters/ParentStateFlowReference", "bindToElement"));
        }
        if (element instanceof XmlFile && (file = ((XmlFile)element).getVirtualFile()) != null) {
            return super.handleElementRename(file.getNameWithoutExtension());
        }
        return this.getElement();
    }

    @NotNull
    private static List<Flow> getAllRelatedFlows(@NotNull GenericDomValue<String> value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/spring/webflow/model/converters/ParentStateFlowReference", "getAllRelatedFlows"));
        }
        Flow flow = (Flow)value.getParentOfType(Flow.class, true);
        if (flow == null) {
            List<Flow> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/ParentStateFlowReference", "getAllRelatedFlows"));
            }
            return list;
        }
        List<Flow> list = flow.getAllRelatedFlows();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/ParentStateFlowReference", "getAllRelatedFlows"));
        }
        return list;
    }
}

