/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.converters.WebflowConverterUtil;
import com.intellij.spring.webflow.model.converters.WebflowLookupUtil;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.resources.WebflowBundle;
import com.intellij.spring.webflow.util.WebflowUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubflowFlowConverter
extends ResolvingConverter<Flow>
implements CustomReferenceConverter<Flow> {
    private static final Condition<Flow> NON_ABSTRACT_FLOW_CONDITION = new Condition<Flow>(){

        public boolean value(Flow flow) {
            return Boolean.TRUE != flow.getAbstract().getValue();
        }
    };

    public Flow fromString(@Nullable @NonNls String s, ConvertContext context) {
        Module module = context.getModule();
        if (module == null) {
            return null;
        }
        Flow flow = WebflowDomModelManager.getInstance(context.getProject()).findFlowByName(module, s);
        if (flow == null) {
            return null;
        }
        return NON_ABSTRACT_FLOW_CONDITION.value((Object)flow) ? flow : null;
    }

    public String toString(@Nullable Flow flow, ConvertContext context) {
        return flow == null ? null : WebflowUtil.getFlowName(flow);
    }

    @NotNull
    public Collection<? extends Flow> getVariants(ConvertContext context) {
        List<Flow> allFlows = WebflowUtil.getAllFlows(context.getModule(), Collections.singletonList(context.getFile().getOriginalFile()));
        List list = ContainerUtil.filter(allFlows, NON_ABSTRACT_FLOW_CONDITION);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/SubflowFlowConverter", "getVariants"));
        }
        return list;
    }

    public LookupElement createLookupElement(Flow flow) {
        return WebflowLookupUtil.forFlow(flow);
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return WebflowBundle.message("parent.flows.converter.cannot.find.flow", s);
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<Flow> flowGenericDomValue, PsiElement element, ConvertContext context) {
        Flow flow = (Flow)flowGenericDomValue.getValue();
        if (flow == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/SubflowFlowConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{SubflowFlowConverter.createFlowNameReference(flow, element)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/SubflowFlowConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    private static PsiReference createFlowNameReference(final @NotNull Flow flow, PsiElement element) {
        if (flow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flow", "com/intellij/spring/webflow/model/converters/SubflowFlowConverter", "createFlowNameReference"));
        }
        return new PsiReferenceBase<PsiElement>(element, true){

            public PsiElement resolve() {
                return WebflowUtil.resolveFlow(flow);
            }

            @NotNull
            public Object[] getVariants() {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/SubflowFlowConverter$2", "getVariants"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }

            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                if (this.resolve() instanceof XmlFile) {
                    String name = FileUtil.getNameWithoutExtension((String)newElementName);
                    return super.handleElementRename(name);
                }
                return super.handleElementRename(newElementName);
            }

            public boolean isReferenceTo(PsiElement element) {
                return super.isReferenceTo(element) || WebflowConverterUtil.isCustomFlowIdReference(element);
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                VirtualFile file;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/webflow/model/converters/SubflowFlowConverter$2", "bindToElement"));
                }
                if (element instanceof XmlFile && (file = ((XmlFile)element).getVirtualFile()) != null) {
                    return super.handleElementRename(file.getNameWithoutExtension());
                }
                return this.getElement();
            }
        };
    }
}

