/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.webflow.model.xml.ViewOwner;
import com.intellij.spring.webflow.util.WebflowUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NotNull;

public class ViewStateIdConverter
implements CustomReferenceConverter {
    @NotNull
    public PsiReference[] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        String stringValue = genericDomValue.getStringValue();
        if (stringValue != null && WebflowUtil.isDynamicExpression(stringValue)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/ViewStateIdConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        ViewOwner viewOwner = (ViewOwner)genericDomValue.getParentOfType(ViewOwner.class, true);
        assert (viewOwner != null);
        if (DomUtil.hasXml(viewOwner.getView())) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/ViewStateIdConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new MyViewStateIdReference(element, genericDomValue)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/ViewStateIdConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    private static class MyViewStateIdReference
    extends PsiReferenceBase<PsiElement> {
        private static final Function<PsiFile, LookupElement> FILE_VARIANT_MAPPER = new Function<PsiFile, LookupElement>(){

            public LookupElement fun(PsiFile psiFile) {
                return LookupElementBuilder.create((Object)psiFile, (String)FileUtil.getNameWithoutExtension((String)psiFile.getName())).withIcon(psiFile.getIcon(0));
            }
        };
        private final GenericDomValue myGenericDomValue;

        private MyViewStateIdReference(PsiElement element, GenericDomValue genericDomValue) {
            super(element, true);
            this.myGenericDomValue = genericDomValue;
        }

        public PsiElement resolve() {
            PsiReference[] reference;
            final String value = this.getValue();
            PsiFile file = (PsiFile)ContainerUtil.find((Object[])this.getFiles(), (Condition)new Condition<PsiFile>(){

                public boolean value(PsiFile psiFile) {
                    return Comparing.strEqual((String)FileUtil.getNameWithoutExtension((String)psiFile.getName()), (String)value);
                }
            });
            if (file != null) {
                return file;
            }
            for (PsiReference psiReference : reference = PathReferenceManager.getInstance().createReferences(this.getElement(), true, new PathReferenceProvider[0])) {
                PsiElement resolve = psiReference.resolve();
                if (resolve == null) continue;
                return resolve;
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            Object[] objectArray = ContainerUtil.map2Array((Object[])this.getFiles(), LookupElement.class, FILE_VARIANT_MAPPER);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/ViewStateIdConverter$MyViewStateIdReference", "getVariants"));
            }
            return objectArray;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/webflow/model/converters/ViewStateIdConverter$MyViewStateIdReference", "bindToElement"));
            }
            if (element instanceof PsiFile) {
                PsiFile psiFile = (PsiFile)element;
                this.myGenericDomValue.setStringValue(FileUtil.getNameWithoutExtension((String)psiFile.getName()));
                return this.myElement;
            }
            return super.bindToElement(element);
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return super.handleElementRename(FileUtil.getNameWithoutExtension((String)newElementName));
        }

        private PsiFile[] getFiles() {
            PsiFile file = this.myElement.getContainingFile().getOriginalFile();
            PsiDirectory directory = file.getContainingDirectory();
            assert (directory != null);
            return (PsiFile[])ArrayUtil.remove((Object[])directory.getFiles(), (Object)file);
        }
    }
}

