/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.css;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.css.CssDialect;
import com.intellij.lang.css.CssDialectMappings;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SwitchToCssDialectQuickFix
implements LocalQuickFix,
IntentionAction,
HighPriorityAction {
    private final CssDialect myToDialect;

    public SwitchToCssDialectQuickFix(CssDialect toDialect) {
        this.myToDialect = toDialect;
    }

    @NotNull
    public String getName() {
        String string = CssBundle.message((String)"switch.to.css.dialect.quickfix.name", (Object[])new Object[]{this.myToDialect.getDisplayName()});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/SwitchToCssDialectQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/SwitchToCssDialectQuickFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/SwitchToCssDialectQuickFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/flex/css/SwitchToCssDialectQuickFix", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/flex/css/SwitchToCssDialectQuickFix", "invoke"));
        }
        this.doApplyFix(project, (PsiElement)file);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/flex/css/SwitchToCssDialectQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/javascript/flex/css/SwitchToCssDialectQuickFix", "applyFix"));
        }
        this.doApplyFix(project, descriptor.getPsiElement());
    }

    private void doApplyFix(final Project project, PsiElement element) {
        final VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        CssDialectMappings mappings = CssDialectMappings.getInstance(project);
        final CssDialect oldDialect = (CssDialect)mappings.getMapping(virtualFile);
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

            public void undo() {
                CssDialectMappings.getInstance(project).setMapping(virtualFile, oldDialect);
            }

            public void redo() {
                CssDialectMappings.getInstance(project).setMapping(virtualFile, SwitchToCssDialectQuickFix.this.myToDialect);
            }
        });
        mappings.setMapping(virtualFile, this.myToDialect);
    }
}

