/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.settings;

import com.intellij.lang.PerFileMappings;
import com.intellij.lang.css.CssDialect;
import com.intellij.lang.css.CssDialectMappings;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.CssBundle;
import com.intellij.util.ui.tree.LanguagePerFileConfigurable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssDialectsConfigurable
extends LanguagePerFileConfigurable<CssDialect> {
    public CssDialectsConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/css/settings/CssDialectsConfigurable", "<init>"));
        }
        super(project, CssDialect.class, (PerFileMappings)CssDialectMappings.getInstance(project), CssBundle.message((String)"css.dialects.caption", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}), CssBundle.message((String)"css.dialects.column.title", (Object[])new Object[0]), CssBundle.message((String)"css.dialects.override.warning.text", (Object[])new Object[0]), CssBundle.message((String)"css.dialects.override.warning.title", (Object[])new Object[0]));
    }

    private static String getDefaultDescriptions(Project project) {
        List dialects = CssDialect.getCustomDialects();
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        ArrayList<String> descr = new ArrayList<String>();
        block0: for (CssDialect dialect : dialects) {
            for (Module module : modules) {
                if (!dialect.isDefault(module)) continue;
                descr.add(dialect.getDefaultDescription());
                continue block0;
            }
        }
        if (descr.size() == 1) {
            return (String)descr.get(0);
        }
        return "<ol><li>" + StringUtil.join(descr, (String)"<li>") + "</ol>";
    }

    @Nls
    public String getDisplayName() {
        return CssBundle.message((String)"css.dialects.title", (Object[])new Object[0]);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return null;
    }

    protected String visualize(@NotNull CssDialect dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/lang/css/settings/CssDialectsConfigurable", "visualize"));
        }
        return dialect.getDisplayName();
    }
}

