/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.colors;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.actions.colors.CssColorIntentionBase;
import com.intellij.psi.css.browse.ColorDeclarationType;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssConvertColorIntention
extends CssColorIntentionBase {
    private final String myColorTypeInFamilyName;
    private boolean myWithAlphaChannel;

    public CssConvertColorIntention(String colorTypeInFamilyName) {
        this.myColorTypeInFamilyName = colorTypeInFamilyName;
    }

    @NotNull
    protected abstract String convert(@NotNull Color var1, @Nullable Project var2);

    @NotNull
    protected abstract String getNewColorTypeName(boolean var1);

    protected abstract boolean isApplied(@NotNull ColorDeclarationType var1, @NotNull Color var2);

    @NotNull
    public String getText() {
        String string = CssBundle.message((String)"css.intentions.color.convert", (Object[])new Object[]{this.getNewColorTypeName(this.myWithAlphaChannel)});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/colors/CssConvertColorIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message((String)"css.intentions.color.convert", (Object[])new Object[]{this.myColorTypeInFamilyName});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/colors/CssConvertColorIntention", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        Color color;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/colors/CssConvertColorIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/actions/colors/CssConvertColorIntention", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        PsiElement colorTerm = CssConvertColorIntention.getPossibleColorTerm(element);
        if (colorTerm != null && (color = CssPsiColorUtil.getColor(colorTerm)) != null) {
            ColorDeclarationType colorType = ColorDeclarationType.fromColorTerm(colorTerm);
            this.myWithAlphaChannel = colorType.withAlphaChannel();
            return this.isApplied(colorType, color);
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/colors/CssConvertColorIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/actions/colors/CssConvertColorIntention", "invoke"));
        }
        PsiElement colorTerm = CssConvertColorIntention.getPossibleColorTerm(element);
        if (colorTerm != null) {
            Color color = CssPsiColorUtil.getColor(colorTerm);
            if (color != null) {
                String newColor = this.convert(color, project);
                colorTerm.replace((PsiElement)CssElementFactory.getInstance((Project)project).createTerm(newColor, colorTerm.getContainingFile().getFileType()));
            } else {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)CssBundle.message((String)"css.intentions.color.convert.error", (Object[])new Object[]{colorTerm.getText(), this.getNewColorTypeName(this.myWithAlphaChannel)}), (String)"", null);
            }
        }
    }
}

