/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.rename;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssIdSelector;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.refactoring.RefactoringFactory;
import com.intellij.refactoring.RenameRefactoring;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssClassOrIdRenameHandler
extends PsiElementRenameHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.css.actions.rename.CssClassOrIdRenameHandler");

    public boolean isAvailableOnDataContext(DataContext dataContext) {
        return CssClassOrIdRenameHandler.getCssReference(dataContext) != null;
    }

    @Nullable
    static Pair<CssReference, PsiElement> getCssReference(@Nullable DataContext context) {
        PsiFile psiFile;
        if (context == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor != null && (psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context)) != null) {
            return CssClassOrIdRenameHandler.extractReference(editor, psiFile);
        }
        return null;
    }

    @Nullable
    public static Pair<CssReference, PsiElement> extractReference(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/css/actions/rename/CssClassOrIdRenameHandler", "extractReference"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/psi/css/actions/rename/CssClassOrIdRenameHandler", "extractReference"));
        }
        if (CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)psiFile) || psiFile.getLanguage() == CssFileType.INSTANCE.getLanguage()) {
            PsiReference ref = psiFile.findReferenceAt(editor.getCaretModel().getOffset());
            CssReference cssRef = null;
            if (ref instanceof CssReference) {
                cssRef = (CssReference)ref;
            } else if (ref instanceof PsiMultiReference) {
                PsiReference[] references;
                for (PsiReference psiReference : references = ((PsiMultiReference)ref).getReferences()) {
                    if (!(psiReference instanceof CssReference)) continue;
                    cssRef = (CssReference)psiReference;
                    break;
                }
            }
            if (cssRef != null) {
                if (cssRef instanceof PsiPolyVariantReference) {
                    ResolveResult[] results = ((PsiPolyVariantReference)cssRef).multiResolve(false);
                    for (PsiReference psiReference : results) {
                        if (!(psiReference.getElement() instanceof CssClass) && !(psiReference.getElement() instanceof CssIdSelector)) continue;
                        return Pair.create((Object)cssRef, (Object)psiReference.getElement());
                    }
                } else {
                    PsiElement psiElement = cssRef.resolve();
                    if (psiElement instanceof CssClass || psiElement instanceof CssIdSelector) {
                        return Pair.create((Object)cssRef, (Object)psiElement);
                    }
                }
            }
        }
        return null;
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/rename/CssClassOrIdRenameHandler", "invoke"));
        }
        if (!this.isRenaming(dataContext)) {
            return;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.rename");
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        Pair<CssReference, PsiElement> reference = CssClassOrIdRenameHandler.getCssReference(dataContext);
        LOG.assertTrue(reference != null);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String initialName = (String)PsiElementRenameHandler.DEFAULT_NAME.getData(dataContext);
            CssClassOrIdRenameHandler.doRename((PsiElement)reference.getSecond(), project, (CssReference)reference.getFirst(), initialName, false, false, false);
            return;
        }
        CssClassOrIdRenameDialog dialog = new CssClassOrIdRenameDialog((CssReference)reference.getFirst(), (PsiElement)reference.getSecond(), editor, project);
        dialog.show();
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/rename/CssClassOrIdRenameHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/psi/css/actions/rename/CssClassOrIdRenameHandler", "invoke"));
        }
    }

    private static List<PsiElement> gatherElementsToRename(CssReference reference, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/rename/CssClassOrIdRenameHandler", "gatherElementsToRename"));
        }
        final ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        final boolean[] id = new boolean[]{false};
        if (reference instanceof PsiPolyVariantReference) {
            ResolveResult[] results;
            for (ResolveResult resolveResult : results = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                PsiElement element = resolveResult.getElement();
                id[0] = element instanceof CssIdSelector;
                result.add(element);
            }
        } else {
            PsiElement element = reference.resolve();
            id[0] = element instanceof CssIdSelector;
            result.add(element);
        }
        final String ident = reference.getCanonicalText();
        PsiSearchHelper.SERVICE.getInstance((Project)project).processElementsWithWord(new TextOccurenceProcessor(){

            public boolean execute(@NotNull PsiElement current, int offsetInElement) {
                VirtualFile file;
                if (current == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/psi/css/actions/rename/CssClassOrIdRenameHandler$1", "execute"));
                }
                ProgressManager.checkCanceled();
                if ((!id[0] && current instanceof CssClass || id[0] && current instanceof CssIdSelector) && ident.equalsIgnoreCase(current.getText().substring(1)) && (file = current.getContainingFile().getVirtualFile()) != null && file.getFileSystem() instanceof LocalFileSystem) {
                    result.add(current);
                }
                return true;
            }
        }, (SearchScope)GlobalSearchScope.projectScope((Project)project), ident, (short)11, false);
        return result;
    }

    public static void doRename(PsiElement toRename, Project project, CssReference reference, String newName, boolean comments, boolean nonJava, boolean preview) {
        RenameRefactoring rename = RefactoringFactory.getInstance((Project)project).createRename(toRename, newName);
        rename.setSearchInComments(comments);
        rename.setSearchInNonJavaFiles(nonJava);
        rename.setPreviewUsages(preview);
        List<PsiElement> elements = CssClassOrIdRenameHandler.gatherElementsToRename(reference, project);
        for (PsiElement element : elements) {
            rename.addElement(element, newName);
        }
        rename.run();
    }

    private static class CssClassOrIdRenameDialog
    extends RenameDialog {
        private final PsiElement myElement;
        private final CssReference myReference;

        private CssClassOrIdRenameDialog(@NotNull CssReference reference, @NotNull PsiElement psiElement, @NotNull Editor editor, @NotNull Project project) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/css/actions/rename/CssClassOrIdRenameHandler$CssClassOrIdRenameDialog", "<init>"));
            }
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/psi/css/actions/rename/CssClassOrIdRenameHandler$CssClassOrIdRenameDialog", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/css/actions/rename/CssClassOrIdRenameHandler$CssClassOrIdRenameDialog", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/rename/CssClassOrIdRenameHandler$CssClassOrIdRenameDialog", "<init>"));
            }
            super(project, psiElement, psiElement, editor);
            this.myElement = psiElement;
            this.myReference = reference;
        }

        protected void doAction() {
            this.close(0);
            CssClassOrIdRenameHandler.doRename(this.myElement, this.myProject, this.myReference, this.getNewName(), this.isSearchInComments(), this.isSearchInNonJavaFiles(), this.isPreviewUsages());
        }
    }
}

