/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.ruleset;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.actions.ruleset.CreateStyleCallback;
import com.intellij.psi.css.actions.ruleset.StyleCreator;
import com.intellij.psi.css.util.AbstractTagUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurrentFileStyleCreator
extends StyleCreator {
    private static final Logger LOG = Logger.getInstance(CurrentFileStyleCreator.class);
    private static final String SELECTOR_LIST_VARIABLE_NAME = "selectorForNewRuleset";

    public CurrentFileStyleCreator(@NotNull PsiFile contextFile) {
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/intellij/psi/css/actions/ruleset/CurrentFileStyleCreator", "<init>"));
        }
        super(CssBundle.message((String)"css.inspections.create.style.current.file", (Object[])new Object[0]), contextFile);
    }

    @Override
    @Nullable
    public CssRuleset createStyleDeclaration(final @NotNull String selector, final CssDeclaration ... declarations) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/psi/css/actions/ruleset/CurrentFileStyleCreator", "createStyleDeclaration"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "com/intellij/psi/css/actions/ruleset/CurrentFileStyleCreator", "createStyleDeclaration"));
        }
        return (CssRuleset)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<CssRuleset>(){

            @Nullable
            public CssRuleset compute() {
                CssRuleset result;
                Project project = CurrentFileStyleCreator.this.myContextFile.getProject();
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                XmlDocument document = ((XmlFile)CurrentFileStyleCreator.this.myContextFile).getDocument();
                assert (document != null);
                XmlTag styleTag = CurrentFileStyleCreator.getOrCreateStyleTag(document);
                if (styleTag == null) {
                    LOG.error((Object)LogMessageEx.createEvent((String)"CSS: Can't create style tag in file", (String)DebugUtil.currentStackTrace(), (Attachment[])new Attachment[]{new Attachment(CurrentFileStyleCreator.this.myContextFile.getName(), CurrentFileStyleCreator.this.myContextFile.getText())}));
                    return null;
                }
                CssRuleset newRuleset = CssElementFactory.getInstance((Project)project).createRuleset(selector, declarations, (FileType)CssFileType.INSTANCE);
                CssStylesheet stylesheetElement = (CssStylesheet)PsiTreeUtil.getChildOfType((PsiElement)styleTag, CssStylesheet.class);
                if (stylesheetElement == null || stylesheetElement.getRulesets().length == 0) {
                    ASTNode endTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(styleTag.getNode());
                    CssStylesheet newStylesheet = (CssStylesheet)PsiTreeUtil.getParentOfType((PsiElement)newRuleset, CssStylesheet.class);
                    if (newStylesheet == null || endTagStart == null) {
                        LogMessageEx.error((Logger)LOG, (String)"CSS: Can't find stylesheet for create ruleset", (String[])new String[]{DebugUtil.currentStackTrace(), newRuleset.getContainingFile().getText()});
                        return null;
                    }
                    newStylesheet = (CssStylesheet)(stylesheetElement != null ? stylesheetElement.replace((PsiElement)newStylesheet) : styleTag.addBefore((PsiElement)newStylesheet, endTagStart.getPsi()));
                    result = (CssRuleset)PsiTreeUtil.findChildOfType((PsiElement)newStylesheet, CssRuleset.class);
                    if (result != null) {
                        CssRulesetList rulesetList = newStylesheet.getRulesetList();
                        PsiElement newLine = PsiParserFacade.SERVICE.getInstance((Project)project).createWhiteSpaceFromText("\n");
                        rulesetList.addBefore(newLine, (PsiElement)result);
                        rulesetList.addAfter(newLine, (PsiElement)result);
                    }
                } else {
                    result = stylesheetElement.addRuleset(newRuleset);
                    if (stylesheetElement.isValid() && result != null && result.isValid()) {
                        PsiElement newLine = PsiParserFacade.SERVICE.getInstance((Project)project).createWhiteSpaceFromText("\n");
                        stylesheetElement.getRulesetList().addAfter(newLine, (PsiElement)result);
                    }
                }
                return StyleCreator.postProcessAndRestoreElement(CurrentFileStyleCreator.this.myContextFile, result, PsiDocumentManager.getInstance((Project)project).getDocument(CurrentFileStyleCreator.this.myContextFile));
            }
        });
    }

    @Override
    public void createStyleDeclarationInteractively(final @NotNull Editor editor, final @NotNull String defaultSelector, final @NotNull Collection<String> selectorVariants, final @Nullable CreateStyleCallback callback, final CssDeclaration ... declarations) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/css/actions/ruleset/CurrentFileStyleCreator", "createStyleDeclarationInteractively"));
        }
        if (defaultSelector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultSelector", "com/intellij/psi/css/actions/ruleset/CurrentFileStyleCreator", "createStyleDeclarationInteractively"));
        }
        if (selectorVariants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorVariants", "com/intellij/psi/css/actions/ruleset/CurrentFileStyleCreator", "createStyleDeclarationInteractively"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "com/intellij/psi/css/actions/ruleset/CurrentFileStyleCreator", "createStyleDeclarationInteractively"));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CssSelectorList selectorList;
                final CssRuleset ruleset = CurrentFileStyleCreator.this.createStyleDeclaration(defaultSelector, declarations);
                Project project = CurrentFileStyleCreator.this.myContextFile.getProject();
                if (ruleset != null && (selectorList = ruleset.getSelectorList()) != null) {
                    TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)selectorList);
                    builder.replaceElement((PsiElement)selectorList, CurrentFileStyleCreator.SELECTOR_LIST_VARIABLE_NAME, (Expression)new SelectorListExpression(selectorVariants), true);
                    Template template = builder.buildInlineTemplate();
                    template.setToReformat(true);
                    Editor topLevelEditor = InjectedLanguageUtil.getTopLevelEditor((Editor)editor);
                    topLevelEditor.getCaretModel().moveToOffset(selectorList.getTextRange().getStartOffset());
                    TemplateManager.getInstance((Project)project).startTemplate(topLevelEditor, template, (TemplateEditingListener)new TemplateEditingAdapter(){
                        public String newSelectorText;
                        {
                            this.newSelectorText = selectorList.getText();
                        }

                        public void beforeTemplateFinished(TemplateState state, Template template) {
                            TextResult variableValue;
                            if (((TemplateImpl)template).getVariableCount() == 1 && (variableValue = state.getVariableValue(((TemplateImpl)template).getVariableNameAt(0))) != null) {
                                this.newSelectorText = variableValue.getText();
                            }
                        }

                        public void templateFinished(Template template, boolean brokenOff) {
                            if (callback != null) {
                                callback.after(this.newSelectorText, ruleset);
                            }
                        }
                    });
                }
            }
        });
    }

    @Nullable
    private static XmlTag getOrCreateStyleTag(XmlDocument document) {
        XmlTag styleTag = AbstractTagUtil.findStyleTag(document);
        if (styleTag == null) {
            styleTag = AbstractTagUtil.addCssStyleTag(document, true);
        }
        return styleTag;
    }

    private static class SelectorListExpression
    extends Expression {
        private final Collection<String> mySelectorNameCandidates;

        public SelectorListExpression(Collection<String> selectorNameCandidates) {
            this.mySelectorNameCandidates = selectorNameCandidates;
        }

        @Nullable
        public Result calculateResult(ExpressionContext context) {
            Editor editor = context.getEditor();
            if (editor != null) {
                TextResult insertedValue;
                TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor);
                TextResult textResult = insertedValue = templateState != null ? templateState.getVariableValue(CurrentFileStyleCreator.SELECTOR_LIST_VARIABLE_NAME) : null;
                if (insertedValue != null && !insertedValue.getText().isEmpty()) {
                    return insertedValue;
                }
            }
            return new TextResult((String)Iterables.getFirst(this.mySelectorNameCandidates, (Object)""));
        }

        @Nullable
        public Result calculateQuickResult(ExpressionContext context) {
            return this.calculateResult(context);
        }

        @Nullable
        public LookupElement[] calculateLookupItems(ExpressionContext context) {
            return (LookupElement[])ContainerUtil.map2Array(this.mySelectorNameCandidates, LookupElement.class, (Function)new Function<String, LookupElement>(){

                public LookupElement fun(String s) {
                    return LookupElementBuilder.create((String)s);
                }
            });
        }
    }
}

