/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.ruleset;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputSelectorDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    @NotNull
    private final LanguageFileType myFileType;
    protected JPanel myMainPanel;
    private NameSuggestionsField selectorField;

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.selectorField;
    }

    public InputSelectorDialog(@NotNull Project project, @NotNull LanguageFileType targetFileType, String[] selectorVariants) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/ruleset/InputSelectorDialog", "<init>"));
        }
        if (targetFileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFileType", "com/intellij/psi/css/actions/ruleset/InputSelectorDialog", "<init>"));
        }
        super(project, false);
        this.myProject = project;
        this.myFileType = targetFileType;
        this.setTitle(CssBundle.message((String)"create.selector.dialog.title", (Object[])new Object[0]));
        this.setModal(true);
        this.setupControls(selectorVariants);
        this.init();
    }

    private void setupControls(String[] suggestions) {
        this.selectorField = new NameSuggestionsField(suggestions, this.myProject, (FileType)this.myFileType);
        this.myMainPanel = JBUI.Panels.simplePanel((Component)this.selectorField);
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String editorValue = this.selectorField.getEnteredName();
        if (StringUtil.isEmptyOrSpaces((String)editorValue) || !this.isSelectorValid(editorValue, this.myFileType)) {
            return new ValidationInfo(CssBundle.message((String)"create.selector.dialog.error.message", (Object[])new Object[0]), (JComponent)this.selectorField);
        }
        return super.doValidate();
    }

    private boolean isSelectorValid(@NotNull String value, LanguageFileType fileType) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/actions/ruleset/InputSelectorDialog", "isSelectorValid"));
        }
        try {
            CssSelectorList list = CssElementFactory.getInstance((Project)this.myProject).createSelectorList(value, (FileType)fileType);
            return value.trim().equals(list.getText());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @NotNull
    public String getValue() {
        String string = this.selectorField.getEnteredName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/ruleset/InputSelectorDialog", "getValue"));
        }
        return string;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        return this.myMainPanel;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return null;
    }

    protected boolean postponeValidation() {
        return false;
    }
}

