/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.browse;

import com.intellij.psi.xml.XmlTag;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public class BrowseCssStylesUtil {
    private BrowseCssStylesUtil() {
    }

    @NotNull
    public static String getFormattedName(@NotNull XmlTag tag) {
        String class_value;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/css/browse/BrowseCssStylesUtil", "getFormattedName"));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(tag.getName());
        String id_value = tag.getAttributeValue("id");
        if (null != id_value) {
            sb.append("#").append(id_value);
        }
        if (null != (class_value = tag.getAttributeValue("class"))) {
            StringTokenizer tokenizer = new StringTokenizer(class_value, " ");
            while (tokenizer.hasMoreTokens()) {
                sb.append(".").append(tokenizer.nextToken());
            }
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/browse/BrowseCssStylesUtil", "getFormattedName"));
        }
        return string;
    }
}

