/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssAttributeRSide;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.impl.CssElementImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import org.jetbrains.annotations.NotNull;

final class CssAttributeRSideImpl
extends CssElementImpl
implements CssAttributeRSide {
    CssAttributeRSideImpl() {
        super(CssElementTypes.CSS_ATTRIBUTE_RSIDE);
    }

    @NotNull
    public String getValue() {
        PsiElement singleElement;
        PsiElement[] children = this.getChildren();
        if (children.length == 1 && (singleElement = children[0]) instanceof CssString) {
            String string = ((CssString)singleElement).getValue();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssAttributeRSideImpl", "getValue"));
            }
            return string;
        }
        StringBuilder result = new StringBuilder();
        for (PsiElement child : children) {
            if (child instanceof PsiWhiteSpace) break;
            result.append(child.getText());
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssAttributeRSideImpl", "getValue"));
        }
        return string;
    }
}

