/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssValueOwner;
import com.intellij.psi.css.impl.CssElementImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CssDeclarationImpl
extends CssElementImpl
implements CssDeclaration {
    private volatile CssPropertyDescriptor myCachedDescriptor;
    private volatile long myDescriptorModCount = -1L;

    CssDeclarationImpl() {
        super(CssElementTypes.CSS_DECLARATION);
    }

    @NotNull
    public String getPropertyName() {
        PsiElement _firstChild = this.getPropertyNameElement();
        if (_firstChild != null) {
            String name = _firstChild.getText();
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c == '\\') continue;
                b.append(c);
            }
            String string = b.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssDeclarationImpl", "getPropertyName"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssDeclarationImpl", "getPropertyName"));
        }
        return "";
    }

    @Nullable
    public PsiElement getPropertyNameElement() {
        ASTNode firstIdentifier = this.findChildByType(TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_IDENT, CssElementTypes.CSS_HASH}));
        return firstIdentifier != null ? firstIdentifier.getPsi() : null;
    }

    @Nullable
    public CssTermList getValue() {
        return this.getChildOfType(CssTermList.class);
    }

    @NotNull
    public TextRange getTrimmedValueTextRange() {
        TextRange textRange = CssPsiUtil.getValueTextRange((CssValueOwner)this);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssDeclarationImpl", "getTrimmedValueTextRange"));
        }
        return textRange;
    }

    @NotNull
    public TextRange getValueTextRange() {
        TextRange textRange = CssPsiUtil.getValueTextRange((CssValueOwner)this);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssDeclarationImpl", "getValueTextRange"));
        }
        return textRange;
    }

    public boolean isShorthandProperty() {
        CssPropertyDescriptor descriptor = this.getDescriptor();
        return descriptor != null && descriptor.isShorthandValue();
    }

    @NotNull
    public String[] expandShorthandProperty() {
        CssPropertyDescriptor descriptor = this.getDescriptor();
        String[] stringArray = descriptor == null ? ArrayUtil.EMPTY_STRING_ARRAY : descriptor.expand((CssDeclaration)this);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssDeclarationImpl", "expandShorthandProperty"));
        }
        return stringArray;
    }

    public String[] getShorthandValue(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/CssDeclarationImpl", "getShorthandValue"));
        }
        PsiElement[] values = this.getShorthandPsiValue(propertyName);
        if (values == null) {
            return null;
        }
        if (values.length == 1 || values.length == 2 && values[0].getText().equals(values[1].getText())) {
            PsiElement term;
            if ("background-size".equalsIgnoreCase(propertyName)) {
                return new String[]{values[0].getText() + " " + values[0].getText()};
            }
            if ("background-position".equalsIgnoreCase(propertyName) && (term = values[0]) instanceof CssTerm && ((CssTerm)term).getTermType() != CssTermTypes.IDENT) {
                return new String[]{values[0].getText() + " " + values[0].getText()};
            }
        }
        String[] result = ArrayUtil.newStringArray((int)values.length);
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].getText();
        }
        return result;
    }

    @Nullable
    public PsiElement[] getShorthandPsiValue(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/CssDeclarationImpl", "getShorthandPsiValue"));
        }
        if (!this.isShorthandProperty()) {
            return null;
        }
        CssPropertyDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            return null;
        }
        String[] propertyNames = this.expandShorthandProperty();
        if (!Arrays.asList(propertyNames).contains(propertyName)) {
            return null;
        }
        return descriptor.getShorthandPsiValue((CssDeclaration)this, propertyName);
    }

    public boolean isImportant() {
        return this.getToken(CssElementTypes.CSS_IMPORTANT) != null;
    }

    public boolean isEqualTo(Object object) {
        if (!(object instanceof CssDeclarationImpl)) {
            return false;
        }
        CssDeclarationImpl declaration = (CssDeclarationImpl)((Object)object);
        CssTermList value = this.getValue();
        CssTermList declarationValue = declaration.getValue();
        return this.getPropertyName().equalsIgnoreCase(declaration.getPropertyName()) && value != null && declarationValue != null && value.getText().equals(declarationValue.getText());
    }

    public int equalityHashCode() {
        return 31 * this.getPropertyName().toLowerCase(Locale.US).hashCode() + CssPsiUtil.hashCodeForElement((PsiElement)this.getValue());
    }

    public void setValue(String propertyValue) throws IncorrectOperationException {
        FileType fileType = this.getContainingFile().getFileType();
        CssTermList newValue = CssElementFactory.getInstance((Project)this.getProject()).createPropertyValue(propertyValue, fileType);
        CssTermList oldValue = this.getValue();
        if (oldValue != null) {
            oldValue.replace((PsiElement)newValue);
        }
    }

    public void clearCaches() {
        this.myCachedDescriptor = null;
        this.myDescriptorModCount = -1L;
        super.clearCaches();
    }

    @Nullable
    public CssPropertyDescriptor getDescriptor() {
        PsiManagerEx manager = this.getManager();
        if (manager == null) {
            return null;
        }
        long curModCount = manager.getModificationTracker().getModificationCount();
        if (this.myDescriptorModCount != curModCount) {
            this.myCachedDescriptor = CssDescriptorsUtil.getPropertyDescriptor((CssDeclaration)this);
            this.myDescriptorModCount = curModCount;
        }
        return this.myCachedDescriptor;
    }

    public boolean isHack() {
        TreeElement lastValueChild;
        String text = this.getText().trim();
        if (CssUtil.isHackPropertyName(text)) {
            return true;
        }
        for (lastValueChild = this.getTreeNext(); lastValueChild != null && CssElementTypes.WHITESPACES.contains(lastValueChild.getElementType()); lastValueChild = lastValueChild.getTreeNext()) {
        }
        if (lastValueChild != null && CssElementTypes.COMMENTS.contains(lastValueChild.getElementType())) {
            return CssUtil.isHackComment(lastValueChild.getText());
        }
        return false;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/CssDeclarationImpl", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssDeclaration((CssDeclaration)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public Collection<? extends CssPropertyDescriptor> getDescriptors() {
        Collection<? extends CssPropertyDescriptor> collection = this.getDescriptors((PsiElement)this);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssDeclarationImpl", "getDescriptors"));
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssPropertyDescriptor> getDescriptors(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/CssDeclarationImpl", "getDescriptors"));
        }
        Collection collection = CssDescriptorsUtil.getPropertyDescriptors((String)this.getPropertyName(), (PsiElement)context);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssDeclarationImpl", "getDescriptors"));
        }
        return collection;
    }
}

