/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.css.impl.CssElementImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssMediumListImpl;
import com.intellij.psi.css.impl.CssUriImpl;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CssImportImpl
extends CssElementImpl
implements CssImport {
    static final ArrayFactory<CssImport> ARRAY_FACTORY = new ArrayFactory<CssImport>(){

        @NotNull
        public CssImport[] create(int count) {
            CssImport[] cssImportArray = count == 0 ? CssImport.EMPTY_ARRAY : new CssImport[count];
            if (cssImportArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssImportImpl$1", "create"));
            }
            return cssImportArray;
        }
    };
    private static final PsiElement[] EMPTY_PSI_ARRAY = new PsiElement[0];

    CssImportImpl() {
        super(CssElementTypes.CSS_IMPORT);
    }

    @NotNull
    public String[] getUriStrings() {
        String[] stringArray = (String[])ContainerUtil.map2Array((Object[])this.getUriElements(), String.class, (Function)new Function<PsiElement, String>(){

            public String fun(PsiElement element) {
                return StringUtil.stripQuotesAroundValue((String)element.getText());
            }
        });
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssImportImpl", "getUriStrings"));
        }
        return stringArray;
    }

    @NotNull
    public PsiElement[] getUriElements() {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        result.addAll(PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, CssString.class));
        List uris = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, CssUriImpl.class);
        for (CssUriImpl uri : uris) {
            PsiElement valueElement = uri.getValueElement();
            if (valueElement == null || valueElement instanceof PsiErrorElement) continue;
            result.add(valueElement);
        }
        PsiElement[] psiElementArray = !result.isEmpty() ? result.toArray(new PsiElement[result.size()]) : EMPTY_PSI_ARRAY;
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssImportImpl", "getUriElements"));
        }
        return psiElementArray;
    }

    @Nullable
    private CssMediumListImpl getMediumList() {
        return this.getChildOfType(CssMediumListImpl.class);
    }

    public boolean isScreen() {
        CssMediumListImpl mediumList = this.getMediumList();
        return mediumList == null || mediumList.getTypes().contains(CssMediaType.SCREEN);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/CssImportImpl", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssImport((CssImport)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiFile[] resolve() {
        ArrayList result = new ArrayList();
        for (PsiElement element : this.getUriElements()) {
            Collections.addAll(result, CssResolveManager.getInstance().resolveFiles(element, this.getContainingFile()));
        }
        PsiFile[] psiFileArray = !result.isEmpty() ? result.toArray(new PsiFile[result.size()]) : PsiFile.EMPTY_ARRAY;
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssImportImpl", "resolve"));
        }
        return psiFileArray;
    }
}

