/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.lang.ASTFactory;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.impl.CssAtRuleImpl;
import com.intellij.psi.css.impl.CssAttributeRSideImpl;
import com.intellij.psi.css.impl.CssBlockImpl;
import com.intellij.psi.css.impl.CssCharsetImpl;
import com.intellij.psi.css.impl.CssCommentImpl;
import com.intellij.psi.css.impl.CssDeclarationImpl;
import com.intellij.psi.css.impl.CssElementImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssExpressionImpl;
import com.intellij.psi.css.impl.CssFunctionImpl;
import com.intellij.psi.css.impl.CssImportImpl;
import com.intellij.psi.css.impl.CssImportListImpl;
import com.intellij.psi.css.impl.CssKeyframesRuleImpl;
import com.intellij.psi.css.impl.CssKeyframesSelectorImpl;
import com.intellij.psi.css.impl.CssMediaExpressionImpl;
import com.intellij.psi.css.impl.CssMediaFeatureImpl;
import com.intellij.psi.css.impl.CssMediaImpl;
import com.intellij.psi.css.impl.CssMediaQueryImpl;
import com.intellij.psi.css.impl.CssMediumListImpl;
import com.intellij.psi.css.impl.CssNamespaceImpl;
import com.intellij.psi.css.impl.CssNamespaceListImpl;
import com.intellij.psi.css.impl.CssOperationImpl;
import com.intellij.psi.css.impl.CssParenthesisedExpressionImpl;
import com.intellij.psi.css.impl.CssSelectorSuffixListImpl;
import com.intellij.psi.css.impl.CssStringImpl;
import com.intellij.psi.css.impl.CssStylesheetImpl;
import com.intellij.psi.css.impl.CssSupportsConditionImpl;
import com.intellij.psi.css.impl.CssSupportsConditionListImpl;
import com.intellij.psi.css.impl.CssTermImpl;
import com.intellij.psi.css.impl.CssTermListImpl;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.impl.CssUriImpl;
import com.intellij.psi.css.impl.stubs.base.CssStubElementType;
import com.intellij.psi.css.impl.util.CssStyleSheetElementType;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import org.jetbrains.annotations.NotNull;

public class CssTreeElementFactory
extends ASTFactory {
    protected boolean isComment(IElementType type) {
        return type == CssElementTypes.CSS_COMMENT;
    }

    @NotNull
    public LeafElement createLeaf(@NotNull IElementType type, @NotNull CharSequence text) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/css/impl/CssTreeElementFactory", "createLeaf"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/css/impl/CssTreeElementFactory", "createLeaf"));
        }
        if (this.isComment(type)) {
            CssCommentImpl cssCommentImpl = new CssCommentImpl(text, type);
            if (cssCommentImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssTreeElementFactory", "createLeaf"));
            }
            return cssCommentImpl;
        }
        LeafPsiElement leafPsiElement = CssTreeElementFactory.createCssToken(type, text);
        if (leafPsiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssTreeElementFactory", "createLeaf"));
        }
        return leafPsiElement;
    }

    public static LeafPsiElement createCssToken(@NotNull IElementType type, CharSequence text) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/css/impl/CssTreeElementFactory", "createCssToken"));
        }
        if (type == CssElementTypes.CSS_COMMENT) {
            return new CssCommentImpl(text, CssElementTypes.CSS_COMMENT);
        }
        return new CssTokenImpl(type, text);
    }

    @NotNull
    public CompositeElement createComposite(IElementType type) {
        CompositeElement compositeElement = CssTreeElementFactory.createCssComposite(type);
        if (compositeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssTreeElementFactory", "createComposite"));
        }
        return compositeElement;
    }

    public LazyParseableElement createLazy(ILazyParseableElementType type, CharSequence text) {
        if (type == CssElementTypes.CSS_FILE) {
            return new FileElement((IElementType)type, text);
        }
        if (type instanceof CssStyleSheetElementType) {
            return new CssStylesheetImpl(text);
        }
        if (type == CssElementTypes.CSS_PAGE_BLOCK || type == CssElementTypes.CSS_DECLARATION_BLOCK) {
            return new CssBlockImpl(text);
        }
        return null;
    }

    private static CompositeElement createCssComposite(IElementType type) {
        CssElementImpl element;
        if (type == CssElementTypes.CSS_NAMESPACE) {
            element = new CssNamespaceImpl();
        } else if (type == CssElementTypes.CSS_KEYFRAMES_SELECTOR) {
            element = new CssKeyframesSelectorImpl();
        } else if (type == CssElementTypes.CSS_DECLARATION) {
            element = new CssDeclarationImpl();
        } else if (type == CssElementTypes.CSS_TERM_LIST) {
            element = new CssTermListImpl();
        } else if (type == CssElementTypes.CSS_TERM) {
            element = new CssTermImpl();
        } else if (type == CssElementTypes.CSS_PARENTHESISED_EXPRESSION) {
            element = new CssParenthesisedExpressionImpl();
        } else if (type == CssElementTypes.CSS_SELECTOR_SUFFIX_LIST) {
            element = new CssSelectorSuffixListImpl();
        } else if (type == CssElementTypes.CSS_EXPRESSION) {
            element = new CssExpressionImpl();
        } else if (type == CssElementTypes.CSS_IMPORT_LIST) {
            element = new CssImportListImpl();
        } else if (type == CssElementTypes.CSS_IMPORT) {
            element = new CssImportImpl();
        } else if (type == CssElementTypes.CSS_URI) {
            element = new CssUriImpl();
        } else if (type == CssElementTypes.CSS_STRING) {
            element = new CssStringImpl();
        } else if (type == CssElementTypes.CSS_MEDIUM_LIST) {
            element = new CssMediumListImpl();
        } else if (type == CssElementTypes.CSS_MEDIA) {
            element = new CssMediaImpl();
        } else if (type == CssElementTypes.CSS_MEDIA_QUERY) {
            element = new CssMediaQueryImpl();
        } else if (type == CssElementTypes.CSS_ATTRIBUTE_RSIDE) {
            element = new CssAttributeRSideImpl();
        } else if (type == CssElementTypes.CSS_FUNCTION) {
            element = new CssFunctionImpl();
        } else if (type == CssElementTypes.CSS_CHARSET) {
            element = new CssCharsetImpl();
        } else if (type == CssElementTypes.CSS_KEYFRAMES_RULE) {
            element = new CssKeyframesRuleImpl();
        } else if (type == CssElementTypes.CSS_PAGE) {
            element = new CssAtRuleImpl(CssContextType.PAGE, type);
        } else if (type == CssElementTypes.CSS_SUPPORTS_CONDITION) {
            element = new CssSupportsConditionImpl();
        } else if (type == CssElementTypes.CSS_SUPPORTS_CONDITION_UNKNOWN_LIST || type == CssElementTypes.CSS_SUPPORTS_CONDITION_AND_LIST || type == CssElementTypes.CSS_SUPPORTS_CONDITION_OR_LIST) {
            element = new CssSupportsConditionListImpl(type);
        } else if (type == CssElementTypes.CSS_NAMESPACE_LIST) {
            element = new CssNamespaceListImpl();
        } else if (type == CssElementTypes.CSS_BINARY_OPERATION || type == CssElementTypes.CSS_UNARY_OPERATION) {
            element = new CssOperationImpl(type);
        } else if (type == CssElementTypes.CSS_FONTFACE) {
            element = new CssAtRuleImpl(CssContextType.FONTFACE, type);
        } else if (type == CssElementTypes.CSS_SUPPORTS) {
            element = new CssAtRuleImpl(CssContextType.SUPPORTS, type);
        } else if (type == CssElementTypes.CSS_VIEWPORT) {
            element = new CssAtRuleImpl(CssContextType.VIEWPORT, type);
        } else if (type == CssElementTypes.CSS_PAGE_MARGIN_RULE) {
            element = new CssAtRuleImpl(CssContextType.PAGE_MARGIN, type);
        } else if (type == CssElementTypes.CSS_COUNTER_STYLE_RULE) {
            element = new CssAtRuleImpl(CssContextType.COUNTER_STYLE, type);
        } else if (type == CssElementTypes.CSS_SCOPE_RULE || type == CssElementTypes.CSS_REGION_RULE || type == CssElementTypes.CSS_APPLY || type == CssElementTypes.CSS_DOCUMENT_RULE) {
            element = new CssAtRuleImpl(CssContextType.NONAME, type);
        } else if (type == CssElementTypes.CSS_BAD_AT_RULE) {
            element = new CssAtRuleImpl(CssContextType.UNKNOWN, type);
        } else if (type == CssElementTypes.CSS_MEDIA_EXPRESSION) {
            element = new CssMediaExpressionImpl();
        } else if (type == CssElementTypes.CSS_MEDIA_FEATURE) {
            element = new CssMediaFeatureImpl();
        } else if (type == CssElementTypes.CSS_NUMBER_TERM || type == CssElementTypes.CSS_EXPRESSION_PARAMETER || type == CssElementTypes.CSS_MEDIA_EXPRESSION_LIST) {
            element = new CssElementImpl(type);
        } else {
            if (type instanceof CssStubElementType) {
                return new CompositeElement(type);
            }
            throw new RuntimeException("Wrong type: " + type);
        }
        return element;
    }
}

