/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.impl.CssElementImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CssUriImpl
extends CssElementImpl
implements CssUri {
    CssUriImpl() {
        super(CssElementTypes.CSS_URI);
    }

    @NotNull
    public String getValue() {
        PsiElement element = this.getValueElement();
        String string = element != null ? element.getText() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssUriImpl", "getValue"));
        }
        return string;
    }

    @Nullable
    public PsiElement getValueElement() {
        PsiElement element;
        PsiElement[] children = this.getChildren();
        PsiElement psiElement = element = children.length > 2 ? children[2] : null;
        if (element instanceof PsiWhiteSpace) {
            element = element.getNextSibling();
        }
        if (element instanceof PsiErrorElement) {
            return null;
        }
        if (element instanceof CssTerm && (children = element.getChildren()).length == 1) {
            return (element = element.getFirstChild()) instanceof CssString ? element : null;
        }
        return element;
    }

    @Nullable
    public PsiElement setValue(@NotNull String newValueString) {
        if (newValueString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValueString", "com/intellij/psi/css/impl/CssUriImpl", "setValue"));
        }
        PsiElement valueElement = this.getValueElement();
        if (this.isValid() && valueElement != null) {
            FileType fileType = this.getContainingFile().getFileType();
            CssElementFactory elementFactory = CssElementFactory.getInstance((Project)this.getProject());
            String text = valueElement.getText().trim();
            Object newValueElement = StringUtil.isQuotedString((String)text) ? elementFactory.createString(text.charAt(0), newValueString, fileType) : elementFactory.createUri(newValueString, fileType).getValueElement();
            if (newValueElement != null) {
                return valueElement.replace(newValueElement);
            }
        }
        return null;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/CssUriImpl", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssUri((CssUri)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean isValidHost() {
        return true;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/css/impl/CssUriImpl", "updateText"));
        }
        return (PsiLanguageInjectionHost)ElementManipulators.handleContentChange((PsiElement)this, (String)text);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        LiteralTextEscaper literalTextEscaper = LiteralTextEscaper.createSimple((PsiLanguageInjectionHost)this);
        if (literalTextEscaper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssUriImpl", "createLiteralTextEscaper"));
        }
        return literalTextEscaper;
    }
}

