/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.manipulators;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssExpression;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CssExpressionManipulator
implements ElementManipulator<CssExpression> {
    public CssExpression handleContentChange(@NotNull CssExpression element, String newContent) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/manipulators/CssExpressionManipulator", "handleContentChange"));
        }
        return this.handleContentChange(element, this.getRangeInElement(element), newContent);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull CssExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/manipulators/CssExpressionManipulator", "getRangeInElement"));
        }
        TextRange textRange = new TextRange(0, element.getTextLength());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/manipulators/CssExpressionManipulator", "getRangeInElement"));
        }
        return textRange;
    }

    public CssExpression handleContentChange(@NotNull CssExpression element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/manipulators/CssExpressionManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/css/impl/manipulators/CssExpressionManipulator", "handleContentChange"));
        }
        CssElement valueNode = element.getValueNode();
        if (valueNode != null) {
            CssElementFactory factory = CssElementFactory.getInstance((Project)element.getProject());
            valueNode.replace((PsiElement)factory.createExpressionParameter(newContent, element.getContainingFile().getFileType()));
        }
        return element;
    }
}

