/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.structure;

import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.impl.structure.CssImportsFilter;
import com.intellij.psi.css.impl.structure.CssMemberKindSorter;
import com.intellij.psi.css.impl.structure.CssStructureViewElement;
import com.intellij.psi.css.impl.structure.CssStructureViewElementsProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssTreeModel
extends TextEditorBasedStructureViewModel
implements StructureViewModel.ElementInfoProvider,
StructureViewModel.ExpandInfoProvider {
    private static final Filter[] CSS_FILTERS = new Filter[]{new CssImportsFilter()};
    private static final Class[] CSS_SUITABLE_CLASSES = new Class[]{CssImport.class, CssAtRule.class, CssRuleset.class};
    private final Sorter[] mySorters;
    @NotNull
    private final Filter[] myFilters;
    @NotNull
    private final Class[] myClasses;

    protected boolean isSuitable(PsiElement element) {
        PsiElement ruleset;
        if (element instanceof CssSelectorSuffix && (ruleset = CssStructureViewElement.getNodeElement(element)) instanceof CssRuleset) {
            CssSelectorSuffix singleSuffix = CssStructureViewElement.retrieveSingleSelectorPrefixFromRuleset((CssRuleset)ruleset);
            return singleSuffix != null;
        }
        return super.isSuitable(element);
    }

    public Object getCurrentEditorElement() {
        CssSelectorSuffix selectorSuffix;
        Object element = super.getCurrentEditorElement();
        if (element instanceof CssRuleset && (selectorSuffix = CssStructureViewElement.retrieveSingleSelectorPrefixFromRuleset((CssRuleset)element)) != null) {
            return selectorSuffix;
        }
        return element;
    }

    public CssTreeModel(@NotNull PsiFile file, @Nullable Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/impl/structure/CssTreeModel", "<init>"));
        }
        super(editor, file);
        this.mySorters = new Sorter[]{CssMemberKindSorter.INSTANCE, Sorter.ALPHA_SORTER};
        this.myFilters = CssTreeModel.initFilters(file);
        this.myClasses = CssTreeModel.initSuitableClasses(file);
    }

    public CssTreeModel(@NotNull CssStylesheet stylesheet, Editor editor) {
        if (stylesheet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stylesheet", "com/intellij/psi/css/impl/structure/CssTreeModel", "<init>"));
        }
        this(stylesheet.getContainingFile(), editor);
    }

    @NotNull
    private static Filter[] initFilters(@NotNull PsiFile contextFile) {
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/intellij/psi/css/impl/structure/CssTreeModel", "initFilters"));
        }
        ArrayList filters = ContainerUtil.newArrayList((Object[])CSS_FILTERS);
        for (CssStructureViewElementsProvider provider : (CssStructureViewElementsProvider[])CssStructureViewElementsProvider.EXTENSION_POINT_NAME.getExtensions()) {
            if (!provider.isMyContext((PsiElement)contextFile)) continue;
            Collections.addAll(filters, provider.getFilters());
        }
        Filter[] filterArray = filters.toArray(new Filter[filters.size()]);
        if (filterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/structure/CssTreeModel", "initFilters"));
        }
        return filterArray;
    }

    @NotNull
    private static Class[] initSuitableClasses(@NotNull PsiFile contextFile) {
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/intellij/psi/css/impl/structure/CssTreeModel", "initSuitableClasses"));
        }
        ArrayList suitableClasses = ContainerUtil.newArrayList((Object[])CSS_SUITABLE_CLASSES);
        for (CssStructureViewElementsProvider provider : (CssStructureViewElementsProvider[])CssStructureViewElementsProvider.EXTENSION_POINT_NAME.getExtensions()) {
            if (!provider.isMyContext((PsiElement)contextFile)) continue;
            Collections.addAll(suitableClasses, provider.getSuitableClasses());
        }
        Class[] classArray = suitableClasses.toArray(new Class[suitableClasses.size()]);
        if (classArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/structure/CssTreeModel", "initSuitableClasses"));
        }
        return classArray;
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        PsiFile file = this.getPsiFile();
        if (file instanceof CssFile) {
            CssStructureViewElement cssStructureViewElement = CssStructureViewElement.create((PsiElement)file, file.getFileType().getIcon(), file.getName());
            if (cssStructureViewElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/structure/CssTreeModel", "getRoot"));
            }
            return cssStructureViewElement;
        }
        CssStructureViewElement cssStructureViewElement = CssStructureViewElement.create((PsiElement)file, CssFileType.INSTANCE.getIcon(), null);
        if (cssStructureViewElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/structure/CssTreeModel", "getRoot"));
        }
        return cssStructureViewElement;
    }

    @NotNull
    public Sorter[] getSorters() {
        if (this.mySorters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/structure/CssTreeModel", "getSorters"));
        }
        return this.mySorters;
    }

    @NotNull
    protected Class[] getSuitableClasses() {
        if (this.myClasses == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/structure/CssTreeModel", "getSuitableClasses"));
        }
        return this.myClasses;
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        return false;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        return element instanceof CssStructureViewElement && ((CssStructureViewElement)element).isAlwaysLeaf();
    }

    @NotNull
    public Filter[] getFilters() {
        if (this.myFilters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/structure/CssTreeModel", "getFilters"));
        }
        return this.myFilters;
    }

    public boolean isAutoExpand(@NotNull StructureViewTreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/structure/CssTreeModel", "isAutoExpand"));
        }
        return element.getValue() instanceof PsiFile || element.getValue() instanceof CssStylesheet;
    }

    public boolean isSmartExpand() {
        return true;
    }
}

