/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssAttribute;
import com.intellij.psi.css.impl.CssAttributeImpl;
import com.intellij.psi.css.impl.stubs.CssAttributeStub;
import com.intellij.psi.css.impl.stubs.base.CssNamedStubElementType;
import com.intellij.psi.css.impl.stubs.base.CssStubElementType;
import com.intellij.psi.css.impl.stubs.index.CssAttributeIndex;
import com.intellij.psi.css.impl.stubs.index.CssClassIndex;
import com.intellij.psi.css.impl.stubs.index.CssIdIndex;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class CssAttributeStubElementType
extends CssNamedStubElementType<CssAttributeStub, CssAttribute> {
    public CssAttributeStubElementType() {
        super("CSS_ATTRIBUTE");
    }

    @Override
    public PsiElement createElement(ASTNode node) {
        return new CssAttributeImpl(node);
    }

    public CssAttribute createPsi(@NotNull CssAttributeStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/css/impl/stubs/CssAttributeStubElementType", "createPsi"));
        }
        return new CssAttributeImpl(stub, (CssNamedStubElementType)this);
    }

    public CssAttributeStub createStub(@NotNull CssAttribute psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/psi/css/impl/stubs/CssAttributeStubElementType", "createStub"));
        }
        return new CssAttributeStub(parentStub, (CssStubElementType)this, psi.getName(), psi.getOperatorType(), psi.getValue(), psi.getTextOffset());
    }

    public void serialize(@NotNull CssAttributeStub stub, @NotNull StubOutputStream stream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/css/impl/stubs/CssAttributeStubElementType", "serialize"));
        }
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/psi/css/impl/stubs/CssAttributeStubElementType", "serialize"));
        }
        this.serializeNameAndTextOffset(stub, stream);
        stream.writeUTFFast(stub.getOperatorType().getPresentation());
        stream.writeUTFFast(stub.getValue());
    }

    @NotNull
    public CssAttributeStub deserialize(@NotNull StubInputStream stream, StubElement parentStub) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/psi/css/impl/stubs/CssAttributeStubElementType", "deserialize"));
        }
        Pair<StringRef, Integer> nameAndTextOffset = this.deserializeNameAndTextOffset(stream);
        String operationType = stream.readUTFFast();
        String value = stream.readUTFFast();
        CssAttributeStub cssAttributeStub = new CssAttributeStub(parentStub, (CssStubElementType)this, (StringRef)nameAndTextOffset.first, CssAttribute.OperatorType.fromString((String)operationType), value, (int)((Integer)nameAndTextOffset.second));
        if (cssAttributeStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/stubs/CssAttributeStubElementType", "deserialize"));
        }
        return cssAttributeStub;
    }

    @Override
    public void indexStub(@NotNull CssAttributeStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/css/impl/stubs/CssAttributeStubElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/psi/css/impl/stubs/CssAttributeStubElementType", "indexStub"));
        }
        if (stub.getOperatorType() == CssAttribute.OperatorType.EQUALS) {
            if ("class".equals(stub.getName())) {
                sink.occurrence(CssClassIndex.KEY, (Object)stub.getValue());
            } else if ("id".equals(stub.getName())) {
                sink.occurrence(CssIdIndex.KEY, (Object)stub.getValue());
            }
        }
        sink.occurrence(CssAttributeIndex.KEY, (Object)stub.getName());
    }
}

