/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.impl.util.CssInHtmlReferenceProvider;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.util.AbstractTagUtil;
import com.intellij.psi.css.util.CssResolveUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.PairConsumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CssInHtmlClassOrIdReferenceProvider
extends CssInHtmlReferenceProvider {
    @Override
    protected void doExtractReferences(@NotNull String text, final @NotNull PsiElement element, final @NotNull List<PsiReference> references, final int offset) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/css/impl/util/CssInHtmlClassOrIdReferenceProvider", "doExtractReferences"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/CssInHtmlClassOrIdReferenceProvider", "doExtractReferences"));
        }
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/psi/css/impl/util/CssInHtmlClassOrIdReferenceProvider", "doExtractReferences"));
        }
        if (text.isEmpty()) {
            return;
        }
        final boolean caseSensitive = AbstractTagUtil.isCaseSensitive(element.getContainingFile().getFileType());
        CssResolveUtil.consumeClassNames(text, element, new PairConsumer<String, TextRange>(){

            public void consume(String token, TextRange range) {
                CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)element);
                assert (descriptorProvider != null);
                range = range.shiftRight(offset);
                references.add(descriptorProvider.getStyleReference(element, range.getStartOffset(), range.getEndOffset(), caseSensitive));
            }
        });
    }

    @Override
    protected boolean isSuitableAttribute(String attrName, XmlAttribute xmlAttribute) {
        return "class".equalsIgnoreCase(attrName) || "id".equalsIgnoreCase(attrName);
    }
}

