/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.css.CssAttribute;
import com.intellij.psi.css.CssAttributeRSide;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssIdSelector;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssPseudoClass;
import com.intellij.psi.css.CssPseudoSelector;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.impl.util.references.CssClassOrIdReference;
import com.intellij.psi.css.impl.util.references.CssFontFamilyReference;
import com.intellij.psi.css.impl.util.references.CssIdentifierReference;
import com.intellij.psi.css.impl.util.references.CssKeyframesReference;
import com.intellij.psi.css.index.CssIndex;
import com.intellij.psi.css.resolve.CssSimpleSelectorReference;
import com.intellij.psi.css.resolve.UrlReference;
import com.intellij.psi.css.util.AbstractTagUtil;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.HtmlUtil;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssReferenceProvider
extends PsiReferenceProvider {
    public static final FileType[] IMAGE_FILE_TYPES = new FileType[]{ImageFileTypeManager.getInstance().getImageFileType()};

    @NotNull
    public PsiReference[] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/CssReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/CssReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getCachedValue((PsiElement)element, (CachedValueProvider)new CachedValueProvider<PsiReference[]>(){

            @Nullable
            public CachedValueProvider.Result<PsiReference[]> compute() {
                return CachedValueProvider.Result.create((Object)CssReferenceProvider.getReferences(element), (Object[])new Object[]{element});
            }
        });
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static PsiReference[] getReferences(PsiElement element) {
        String propertyName;
        CssDeclaration declaration;
        CssAttribute cssAttribute;
        PsiElement parent = element.getParent();
        if (parent instanceof CssClass || parent instanceof CssIdSelector) {
            FileType fileType = element.getContainingFile().getFileType();
            return new PsiReference[]{new CssClassOrIdReference(element, AbstractTagUtil.isCaseSensitive(fileType))};
        }
        if (parent instanceof CssAttributeRSide && (cssAttribute = (CssAttribute)PsiTreeUtil.getParentOfType((PsiElement)parent, CssAttribute.class)) != null) {
            FileType fileType = element.getContainingFile().getFileType();
            String cssAttributeName = cssAttribute.getName();
            if ("id".equals(cssAttributeName)) {
                return new PsiReference[]{new CssClassOrIdReference(element, AbstractTagUtil.isCaseSensitive(fileType)){

                    @Override
                    protected boolean isId() {
                        return true;
                    }

                    @Override
                    protected boolean hasExplicitIdMark() {
                        return false;
                    }
                }};
            }
            if ("class".equals(cssAttributeName)) {
                return new PsiReference[]{new CssClassOrIdReference(element, AbstractTagUtil.isCaseSensitive(fileType)){

                    @Override
                    protected boolean isId() {
                        return false;
                    }
                }};
            }
        }
        if (parent instanceof CssSimpleSelector) {
            return new PsiReference[]{new CssSimpleSelectorReference(element)};
        }
        if (parent instanceof CssPseudoSelector || element instanceof CssFunction) {
            return PsiReference.EMPTY_ARRAY;
        }
        IElementType elementType = element.getNode().getElementType();
        if (CssReferenceProvider.isStringOrUrl(element)) {
            return CssReferenceProvider.getDefaultStringAndUrlReferences(element);
        }
        if (elementType == CssElementTypes.CSS_IDENT && parent instanceof CssTerm && (declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)parent, CssDeclaration.class)) != null && ("animation-name".equalsIgnoreCase(propertyName = declaration.getPropertyName()) || "animation".equalsIgnoreCase(propertyName))) {
            return new PsiReference[]{new CssKeyframesReference(element)};
        }
        if (elementType == CssElementTypes.CSS_HASH || elementType == CssElementTypes.CSS_IDENT) {
            return new PsiReference[]{new CssIdentifierReference(element)};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @NotNull
    private static PsiReference[] getDefaultStringAndUrlReferences(@Nullable PsiElement urlElement) {
        if (urlElement == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssReferenceProvider", "getDefaultStringAndUrlReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (CssReferenceProvider.isImport(urlElement)) {
            PsiReference[] psiReferenceArray = CssReferenceProvider.getFileReferences(urlElement, true, new FileType[]{CssFileType.INSTANCE});
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssReferenceProvider", "getDefaultStringAndUrlReferences"));
            }
            return psiReferenceArray;
        }
        if (CssReferenceProvider.isInsideImageFunction(urlElement) || CssReferenceProvider.isUriElement(urlElement)) {
            PsiReference[] psiReferenceArray = CssReferenceProvider.getFileReferences(urlElement, false, IMAGE_FILE_TYPES);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssReferenceProvider", "getDefaultStringAndUrlReferences"));
            }
            return psiReferenceArray;
        }
        if (urlElement instanceof CssString && CssReferenceProvider.isFontFamilyPropertyValue(urlElement)) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new CssFontFamilyReference((CssString)urlElement)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssReferenceProvider", "getDefaultStringAndUrlReferences"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssReferenceProvider", "getDefaultStringAndUrlReferences"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public static boolean isStringOrUrl(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/CssReferenceProvider", "isStringOrUrl"));
        }
        return element instanceof CssString && CssReferenceProvider.isSimpleString((CssString)element) || element.getNode().getElementType() == CssElementTypes.CSS_URL;
    }

    private static boolean isFontFamilyPropertyValue(@Nullable PsiElement element) {
        CssDeclaration declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, CssDeclaration.class, (boolean)true);
        if (declaration != null) {
            for (CssPropertyDescriptor descriptor : declaration.getDescriptors()) {
                if (!CssIndex.isFontOrFontFamily(descriptor.getPropertyName())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isUriElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/CssReferenceProvider", "isUriElement"));
        }
        PsiElement parent = element.getParent();
        return parent instanceof CssUri || parent instanceof CssTerm && parent.getParent() instanceof CssUri;
    }

    @Contract(value="null -> false")
    public static boolean isSimpleString(@Nullable CssString string) {
        return string != null && string.getChildren().length <= 1;
    }

    public static boolean isDataUrl(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/CssReferenceProvider", "isDataUrl"));
        }
        return ElementManipulators.getValueText((PsiElement)element).startsWith("data:");
    }

    public static boolean isUrlLink(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/CssReferenceProvider", "isUrlLink"));
        }
        return HtmlUtil.hasHtmlPrefix((String)ElementManipulators.getValueText((PsiElement)element));
    }

    public static boolean isImport(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/CssReferenceProvider", "isImport"));
        }
        PsiElement parent = element.getParent();
        if (!CssReferenceProvider.isStringOrUrl(element) || CssReferenceProvider.isDataUrl(element)) {
            return false;
        }
        return parent instanceof CssImport || parent instanceof CssUri && parent.getParent() instanceof CssImport;
    }

    public static boolean isInsideImageFunction(@Nullable PsiElement element) {
        CssFunction function = (CssFunction)PsiTreeUtil.getParentOfType((PsiElement)element, CssFunction.class);
        return function != null && "image".equalsIgnoreCase(function.getName());
    }

    @NotNull
    public static PsiReference[] getFileReferences(@Nullable PsiElement element, boolean typedReference, FileType ... suitableFileTypes) {
        if (element == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssReferenceProvider", "getFileReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiLanguageInjectionHost && InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)((PsiLanguageInjectionHost)parent))) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssReferenceProvider", "getFileReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (ElementManipulators.getValueText((PsiElement)element).isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssReferenceProvider", "getFileReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (CssReferenceProvider.isUrlLink(element)) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new UrlReference(element, (FileType)(typedReference ? CssFileType.INSTANCE : null), !typedReference)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssReferenceProvider", "getFileReferences"));
            }
            return psiReferenceArray;
        }
        if (!CssReferenceProvider.isDataUrl(element)) {
            PsiReference[] psiReferenceArray = PathReferenceManager.getInstance().createReferences(element, false, true, true, suitableFileTypes, new PathReferenceProvider[0]);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssReferenceProvider", "getFileReferences"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssReferenceProvider", "getFileReferences"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public static class CssReferenceFilter
    implements ElementFilter {
        public boolean isAcceptable(Object element, PsiElement context) {
            PsiElement psiElement = (PsiElement)element;
            if (!psiElement.isValid()) {
                return false;
            }
            if (CssPsiUtil.getStylesheetLanguage((PsiElement)context) == null && context.getContainingFile().getFileType() != CssFileType.INSTANCE && !CssSupportLoader.isInFileThatSupportsCssResolve(context)) {
                return false;
            }
            if (element instanceof CssTokenImpl) {
                PsiElement parent = psiElement.getParent();
                if (parent != null) {
                    if (parent instanceof CssDeclaration || parent instanceof CssSimpleSelector || parent instanceof CssClass || parent instanceof CssIdSelector || parent instanceof CssPseudoClass || parent instanceof CssAttributeRSide || parent instanceof CssFunction) {
                        return true;
                    }
                    PsiElement grandParent = parent.getParent();
                    if (grandParent != null && (grandParent instanceof CssTermList || grandParent.getParent() instanceof CssTermList) && PsiTreeUtil.getParentOfType((PsiElement)parent, CssDeclaration.class) != null || parent instanceof CssUri) {
                        return true;
                    }
                }
            } else if (CssReferenceProvider.isStringOrUrl(psiElement)) {
                return true;
            }
            return false;
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    }
}

