/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssAttribute;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssIdSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.impl.stubs.index.CssIndexUtil;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.psi.css.resolve.HtmlCssClassOrIdReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssClassOrIdReference
extends PsiPolyVariantReferenceBase<PsiElement>
implements CssReference {
    private final boolean myCaseSensitive;
    private final boolean myIsExternalCssReference;

    public CssClassOrIdReference(PsiElement element, boolean caseSensitive) {
        this(element, null, caseSensitive);
    }

    public CssClassOrIdReference(PsiElement element, @Nullable TextRange range, boolean caseSensitive) {
        super(element, range);
        this.myCaseSensitive = caseSensitive;
        this.myIsExternalCssReference = this.isExternalCssReference();
    }

    public CssClassOrIdReference(PsiElement element, @Nullable TextRange range, boolean caseSensitive, boolean isExternalCssReference) {
        super(element, range);
        this.myCaseSensitive = caseSensitive;
        this.myIsExternalCssReference = isExternalCssReference;
    }

    protected TextRange calculateDefaultRangeInElement() {
        TextRange range = super.calculateDefaultRangeInElement();
        boolean id = this.isId();
        if (range.isEmpty()) {
            return range;
        }
        if (id && this.hasExplicitIdMark() || !id && this.hasExplicitClassMark()) {
            range = new TextRange(range.getStartOffset() + 1, range.getEndOffset());
        }
        return range;
    }

    protected boolean hasExplicitIdMark() {
        return true;
    }

    protected boolean hasExplicitClassMark() {
        return false;
    }

    protected boolean isExternalCssReference() {
        return CssUtil.isSelectorInjected(this.myElement);
    }

    public boolean isReferenceTo(PsiElement element) {
        ResolveResult[] resolveResults;
        boolean isId = this.isId();
        if (!isId && element instanceof CssClass || isId && element instanceof CssIdSelector) {
            String canonicalText = this.getCanonicalText();
            String name = ((PsiNamedElement)element).getName();
            return (this.myCaseSensitive && canonicalText.equals(name) || !this.myCaseSensitive && canonicalText.equalsIgnoreCase(name)) && element.getContainingFile() == this.myElement.getContainingFile();
        }
        for (ResolveResult r : resolveResults = this.multiResolve(false)) {
            if (!this.getElement().getManager().areElementsEquivalent(element, r.getElement())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        CssSelectorSuffixType selectorType;
        THashSet completions = new THashSet(1);
        CssSelectorSuffixType cssSelectorSuffixType = selectorType = this.isId() ? CssSelectorSuffixType.ID : CssSelectorSuffixType.CLASS;
        if (this.myIsExternalCssReference) {
            Project project = this.myElement.getProject();
            GlobalSearchScope scope = this.getSearchScope();
            final ArrayList result = ContainerUtil.newArrayList();
            CssIndexUtil.processAllSelectorNamesInScope(selectorType, project, scope, new Processor<String>(){

                public boolean process(String suffix) {
                    result.add(LookupElementBuilder.create((String)suffix).withIcon(selectorType.getIcon()));
                    return true;
                }
            });
            CssIndexUtil.processSelectorNamesFromHtmlAttributes(scope, new Processor<String>(){

                public boolean process(String suffix) {
                    if (suffix.length() < 2) {
                        return true;
                    }
                    if (selectorType == CssSelectorSuffixType.CLASS && StringUtil.startsWithChar((CharSequence)suffix, (char)'.') || selectorType == CssSelectorSuffixType.ID && StringUtil.startsWithChar((CharSequence)suffix, (char)'#')) {
                        result.add(LookupElementBuilder.create((String)suffix.substring(1)).withIcon(selectorType.getIcon()));
                    }
                    return true;
                }
            });
            Object[] objectArray = ArrayUtil.toObjectArray((Collection)result);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/references/CssClassOrIdReference", "getVariants"));
            }
            return objectArray;
        }
        boolean isClass = !this.isId();
        PsiFile file = this.myElement.getContainingFile();
        file = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file);
        final PsiRecursiveElementVisitor collectVariantsVisitor = new PsiRecursiveElementVisitor((Set)completions, isClass){
            final /* synthetic */ Set val$completions;
            final /* synthetic */ boolean val$isClass;
            {
                this.val$completions = set;
                this.val$isClass = bl;
            }

            public void visitElement(PsiElement element) {
                if (element instanceof CssSelectorSuffix && ((CssSelectorSuffix)element).getType() == selectorType) {
                    if (element instanceof CssAttribute) {
                        String value = ((CssAttribute)element).getValue();
                        if (((CssAttribute)element).getOperatorType() == CssAttribute.OperatorType.EQUALS && StringUtil.isNotEmpty((String)value)) {
                            String attributeName = ((CssAttribute)element).getName();
                            if ("id".equalsIgnoreCase(attributeName)) {
                                this.val$completions.add(CssClassOrIdReference.createLookupItem(value, false));
                            } else if ("class".equalsIgnoreCase(attributeName)) {
                                this.val$completions.add(CssClassOrIdReference.createLookupItem(value, true));
                            }
                        }
                    } else {
                        String name = ((CssSelectorSuffix)element).getName();
                        if (StringUtil.isNotEmpty((String)name)) {
                            this.val$completions.add(CssClassOrIdReference.createLookupItem(name, element instanceof CssClass));
                        }
                    }
                } else if (element instanceof XmlAttributeValue) {
                    PsiReference[] references = element.getReferences();
                    if (references.length > 0) {
                        XmlAttribute parentAttribute;
                        PsiElement psiElement = element.getParent();
                        boolean isClassAttribute = false;
                        if (psiElement instanceof XmlAttribute && (parentAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class)) != null) {
                            String name = parentAttribute.getName();
                            boolean bl = isClassAttribute = !name.toLowerCase(Locale.US).endsWith("id");
                        }
                        if (this.val$isClass == isClassAttribute) {
                            for (PsiReference reference : references) {
                                if (!(reference instanceof HtmlCssClassOrIdReference)) continue;
                                PsiElement element1 = reference.getElement();
                                String s = element1.getText();
                                TextRange range = reference.getRangeInElement();
                                this.val$completions.add(CssClassOrIdReference.createLookupItem(range.substring(s), this.val$isClass));
                            }
                        }
                    }
                } else {
                    super.visitElement(element);
                }
            }
        };
        if (file instanceof CssFile) {
            CssStylesheet stylesheet = ((CssFile)file).getStylesheet();
            if (stylesheet != null) {
                CssUtil.processStylesheetWithImports(stylesheet, new Processor<PsiFile>(){

                    public boolean process(PsiFile file) {
                        file.acceptChildren((PsiElementVisitor)collectVariantsVisitor);
                        return true;
                    }
                }, this.myElement, false);
            }
        } else {
            file.acceptChildren((PsiElementVisitor)collectVariantsVisitor);
        }
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)completions);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/references/CssClassOrIdReference", "getVariants"));
        }
        return objectArray;
    }

    protected GlobalSearchScope getSearchScope() {
        return CssUtil.getCompletionAndResolvingScopeForElement(this.myElement);
    }

    protected boolean isId() {
        return !(this.myElement.getParent() instanceof CssClass);
    }

    public boolean isSoft() {
        return this.myIsExternalCssReference;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = CssBundle.message((String)(this.isId() ? "invalid.css.id.reference" : "invalid.css.class.reference"), (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/references/CssClassOrIdReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        if (this.myIsExternalCssReference) {
            Project project = this.myElement.getProject();
            String text = this.getCanonicalText();
            CssSelectorSuffixType selectorType = this.isId() ? CssSelectorSuffixType.ID : CssSelectorSuffixType.CLASS;
            final ArrayList result = ContainerUtil.newArrayList();
            CssIndexUtil.processSelectorSuffixes(selectorType, text, project, this.getSearchScope(), (Processor<? super CssSelectorSuffix>)new Processor<CssSelectorSuffix>(){

                public boolean process(CssSelectorSuffix selectorSuffix) {
                    return result.add(new PsiElementResolveResult((PsiElement)selectorSuffix));
                }
            });
            ResolveResult[] resolveResultArray = result.toArray(new ResolveResult[result.size()]);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/references/CssClassOrIdReference", "multiResolve"));
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult(this.myElement.getParent())};
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/references/CssClassOrIdReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    private static LookupElement createLookupItem(String name, boolean isClass) {
        return LookupElementBuilder.create((String)name).withIcon(isClass ? AllIcons.Xml.Css_class : AllIcons.Xml.Html_id);
    }
}

