/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.scheme;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssMediaFeatureDescriptor;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueValidator;
import com.intellij.psi.css.impl.descriptor.value.CssValueValidatorImpl;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorFactory2;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssElementDescriptorFactory;
import com.intellij.psi.css.resolve.HtmlCssClassOrIdReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssElementDescriptorProviderImpl
extends CssElementDescriptorProvider {
    private static final String[] KEYFRAMES_SELECTORS = new String[]{"to", "from"};

    public boolean isMyContext(@Nullable PsiElement context) {
        return true;
    }

    @Nullable
    public CssPropertyDescriptor getPropertyDescriptor(@NotNull String propertyName, @Nullable PsiElement context) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getPropertyDescriptor"));
        }
        return CssElementDescriptorFactory.getDescriptor(propertyName);
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> findPseudoSelectorDescriptors(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "findPseudoSelectorDescriptors"));
        }
        Collection<CssPseudoSelectorDescriptor> collection = CssElementDescriptorProviderImpl.factory().findPseudoSelector(name);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "findPseudoSelectorDescriptors"));
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssValueDescriptor> getNamedValueDescriptors(@NotNull String name, @Nullable CssValueDescriptor parent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getNamedValueDescriptors"));
        }
        Collection<CssValueDescriptor> collection = CssElementDescriptorProviderImpl.factory().findNamedValue(name, parent);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getNamedValueDescriptors"));
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssPropertyDescriptor> findPropertyDescriptors(@NotNull String propertyName, @Nullable PsiElement context) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "findPropertyDescriptors"));
        }
        Collection<CssPropertyDescriptor> collection = CssElementDescriptorProviderImpl.factory().findProperty(propertyName);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "findPropertyDescriptors"));
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssFunctionDescriptor> findFunctionDescriptors(@NotNull String functionName, @Nullable PsiElement context) {
        Collection propertyDescriptors;
        CssDeclaration declaration;
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "findFunctionDescriptors"));
        }
        if (functionName.equalsIgnoreCase("toggle") && (declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)context, CssDeclaration.class)) != null && !(propertyDescriptors = declaration.getDescriptors()).isEmpty()) {
            List list = ContainerUtil.map((Collection)propertyDescriptors, (Function)new Function<CssPropertyDescriptor, CssFunctionDescriptor>(){

                public CssFunctionDescriptor fun(CssPropertyDescriptor descriptor) {
                    return CssElementDescriptorProviderImpl.factory().createToggleFunctionDescriptorFromPropertyDescriptor(descriptor);
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "findFunctionDescriptors"));
            }
            return list;
        }
        Collection<CssFunctionDescriptor> collection = CssElementDescriptorProviderImpl.factory().findFunction(functionName);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "findFunctionDescriptors"));
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssMediaFeatureDescriptor> findMediaFeatureDescriptors(@NotNull String mediaFeatureName, @Nullable PsiElement context) {
        if (mediaFeatureName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mediaFeatureName", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "findMediaFeatureDescriptors"));
        }
        Collection<CssMediaFeatureDescriptor> collection = CssElementDescriptorProviderImpl.factory().findMediaFeature(mediaFeatureName);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "findMediaFeatureDescriptors"));
        }
        return collection;
    }

    private static CssElementDescriptorFactory2 factory() {
        return CssElementDescriptorFactory2.getInstance();
    }

    public boolean isPossibleSelector(@NotNull String selector, @NotNull PsiElement context) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "isPossibleSelector"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "isPossibleSelector"));
        }
        if (CssUtil.containsStrangeCharacter(selector)) {
            return true;
        }
        return ArrayUtilRt.find((Object[])CssElementDescriptorProviderImpl.getPossibleTagsForContext(context), (Object)selector.toLowerCase(Locale.US)) >= 0;
    }

    public boolean isPossiblePseudoSelector(@NotNull String selectorName, @Nullable PsiElement context) {
        if (selectorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorName", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "isPossiblePseudoSelector"));
        }
        return !CssDescriptorsUtil.filterDescriptorsByContext(this.findPseudoSelectorDescriptors(selectorName), (PsiElement)context).isEmpty();
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> getAllPseudoSelectorDescriptors(@Nullable PsiElement context) {
        Collection collection = CssDescriptorsUtil.filterDescriptorsByContext((Collection)CssElementDescriptorProviderImpl.factory().getPseudoSelectors().values(), (PsiElement)context);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getAllPseudoSelectorDescriptors"));
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssPropertyDescriptor> getAllPropertyDescriptors(@Nullable PsiElement context) {
        Collection collection = CssDescriptorsUtil.filterDescriptorsByMediaType((Collection)CssDescriptorsUtil.filterDescriptorsByContext((Collection)CssElementDescriptorProviderImpl.factory().getProperties().values(), (PsiElement)context), (PsiElement)context);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getAllPropertyDescriptors"));
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssMediaFeatureDescriptor> getAllMediaFeatureDescriptors(@Nullable PsiElement context) {
        Collection collection = CssDescriptorsUtil.filterDescriptorsByMediaType((Collection)CssDescriptorsUtil.filterDescriptorsByContext((Collection)CssElementDescriptorProviderImpl.factory().getMediaFeatures().values(), (PsiElement)context), (PsiElement)context);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getAllMediaFeatureDescriptors"));
        }
        return collection;
    }

    @NotNull
    public String[] getSimpleSelectors(@Nullable PsiElement context) {
        String[] stringArray = CssElementDescriptorProviderImpl.getPossibleTagsForContext(context);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getSimpleSelectors"));
        }
        return stringArray;
    }

    @NotNull
    public PsiElement[] getDeclarationsForSimpleSelector(@NotNull CssSimpleSelector selector) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getDeclarationsForSimpleSelector"));
        }
        PsiElement[] psiElementArray = new PsiElement[]{selector};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getDeclarationsForSimpleSelector"));
        }
        return psiElementArray;
    }

    public boolean providesClassicCss() {
        return true;
    }

    @NotNull
    public PsiReference getStyleReference(PsiElement element, int start, int end, boolean caseSensitive) {
        HtmlCssClassOrIdReference htmlCssClassOrIdReference = new HtmlCssClassOrIdReference(element, start, end, caseSensitive, true);
        if (htmlCssClassOrIdReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getStyleReference"));
        }
        return htmlCssClassOrIdReference;
    }

    @NotNull
    public CssValueValidator getValueValidator() {
        CssValueValidatorImpl cssValueValidatorImpl = new CssValueValidatorImpl(this);
        if (cssValueValidatorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl", "getValueValidator"));
        }
        return cssValueValidatorImpl;
    }

    public CssContextType getCssContextType(@Nullable PsiElement context) {
        if (context == null) {
            return CssContextType.ANY;
        }
        CssAtRule atRule = (CssAtRule)PsiTreeUtil.getParentOfType((PsiElement)context, CssAtRule.class);
        if (atRule != null) {
            CssContextType atRuleType = atRule.getType();
            if (atRuleType == CssContextType.MEDIA || atRuleType == CssContextType.SUPPORTS || atRuleType == CssContextType.KEYFRAMES) {
                CssContextType parentContextType = this.getCssContextType((PsiElement)atRule);
                return parentContextType != CssContextType.NONE ? parentContextType : CssContextType.NONAME;
            }
            return atRuleType;
        }
        CssRuleset ruleset = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)context, CssRuleset.class);
        if (ruleset != null) {
            return CssContextType.NONAME;
        }
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)context, XmlAttribute.class);
        if (attribute != null && "style".equalsIgnoreCase(attribute.getName())) {
            return CssContextType.NONAME;
        }
        return CssContextType.NONE;
    }

    private static String[] getPossibleTagsForContext(PsiElement context) {
        if (CssUtil.isInsideKeyframes(context)) {
            return KEYFRAMES_SELECTORS;
        }
        if (CssUtil.isInsideFontFace(context) || CssUtil.isInsidePageRuleset(context)) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        Object[] customTags = HtmlUtil.getCustomTagDescriptors((PsiElement)context);
        return ArrayUtil.mergeArrays((String[])HtmlUtil.getHtmlTagNames(), (String[])((String[])ContainerUtil.map((Object[])customTags, (Function)new Function<XmlElementDescriptor, String>(){

            public String fun(XmlElementDescriptor descriptor) {
                return descriptor.getName();
            }
        }, (Object[])ArrayUtil.EMPTY_STRING_ARRAY)));
    }

    public boolean shouldAskOtherProviders(@Nullable PsiElement context) {
        return false;
    }
}

