/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssPropertyValue;
import com.intellij.psi.css.impl.util.table.CssCompletionContext;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssPropertyDescriptorImpl;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.css.impl.util.table.CssPropertyValueImpl;
import com.intellij.psi.css.impl.util.table.CssReferencePropertyValue;
import com.intellij.psi.css.impl.util.table.CssTableValueVisitor;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssShorthandExpandProcessor {
    private final CssPropertyDescriptor myDescriptor;
    @NonNls
    private static final String[] VALUE_4 = new String[]{"top", "right", "bottom", "left"};

    public CssShorthandExpandProcessor(@NotNull CssPropertyDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/impl/util/table/CssShorthandExpandProcessor", "<init>"));
        }
        this.myDescriptor = descriptor;
    }

    public static CssShorthandExpandProcessor create(@NotNull CssPropertyDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/impl/util/table/CssShorthandExpandProcessor", "create"));
        }
        assert (descriptor.isShorthandValue());
        return new CssShorthandExpandProcessor(descriptor);
    }

    @NotNull
    public String[] expand(@NotNull CssDeclaration decl) {
        String vendorPrefix;
        if (decl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decl", "com/intellij/psi/css/impl/util/table/CssShorthandExpandProcessor", "expand"));
        }
        String propertyName = this.myDescriptor.getPropertyName();
        String string = vendorPrefix = !propertyName.equalsIgnoreCase(decl.getPropertyName()) ? CssPropertyUtil.getVendorPrefix(decl.getPropertyName()) : "";
        if (propertyName.startsWith("-moz-border-radius")) {
            String[] stringArray = new String[]{"-moz-border-radius-topleft", "-moz-border-radius-topright", "-moz-border-radius-bottomright", "-moz-border-radius-bottomleft"};
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssShorthandExpandProcessor", "expand"));
            }
            return stringArray;
        }
        if (propertyName.contains("border-radius") || propertyName.contains("border-corner")) {
            int index = propertyName.indexOf("border-radius");
            String propertyType = "radius";
            if (index == -1) {
                index = propertyName.indexOf("border-corner");
                propertyType = "image";
            }
            String prefix = vendorPrefix + propertyName.substring(0, index);
            String[] stringArray = new String[]{prefix + "border-top-left-" + propertyType, prefix + "border-top-right-" + propertyType, prefix + "border-bottom-right-" + propertyType, prefix + "border-bottom-left-" + propertyType};
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssShorthandExpandProcessor", "expand"));
            }
            return stringArray;
        }
        if (propertyName.contains("border-image")) {
            String prefix = vendorPrefix + propertyName.substring(0, propertyName.indexOf("border-image"));
            String[] stringArray = new String[]{prefix + "border-top-image", prefix + "border-right-image", prefix + "border-bottom-image", prefix + "border-left-image"};
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssShorthandExpandProcessor", "expand"));
            }
            return stringArray;
        }
        if (this.myDescriptor.is4ValueProperty()) {
            String[] stringArray = this.suggestValueNames();
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssShorthandExpandProcessor", "expand"));
            }
            return stringArray;
        }
        if ("overflow".equals(propertyName)) {
            String[] stringArray = new String[]{"overflow-x", "overflow-y"};
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssShorthandExpandProcessor", "expand"));
            }
            return stringArray;
        }
        Map<String, String> refNames = this.processReferences(decl);
        Set<String> keys = refNames.keySet();
        String[] stringArray = ArrayUtil.toStringArray(keys);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssShorthandExpandProcessor", "expand"));
        }
        return stringArray;
    }

    @Nullable
    public CssPropertyValue getPropertyValue(@NotNull CssDeclaration decl, @NotNull String propertyName) {
        if (decl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decl", "com/intellij/psi/css/impl/util/table/CssShorthandExpandProcessor", "getPropertyValue"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/table/CssShorthandExpandProcessor", "getPropertyValue"));
        }
        if (this.myDescriptor.is4ValueProperty()) {
            return this.myDescriptor.getValue();
        }
        Map<String, String> expanded2refName = this.processReferences(decl);
        String refName = expanded2refName.get(propertyName);
        if (refName != null) {
            return this.myDescriptor.getReferencedPropertyValue(refName);
        }
        return null;
    }

    @NotNull
    private Map<String, String> processReferences(final @NotNull CssDeclaration decl) {
        if (decl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decl", "com/intellij/psi/css/impl/util/table/CssShorthandExpandProcessor", "processReferences"));
        }
        CssCompletionContext context = CssPropertyDescriptorImpl.buildFullContext(decl);
        final String vendorPrefix = CssPropertyUtil.getVendorPrefix(decl.getPropertyName());
        final HashMap<String, String> result = new HashMap<String, String>();
        if (context != null) {
            this.myDescriptor.getValue().accept((CssTableValueVisitor)new CssTableValueVisitor.Recursive<CssPropertyValueImpl>(){
                final CssElementDescriptorProvider provider;
                {
                    this.provider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)decl);
                }

                public void visitValue(@NotNull CssPropertyValueImpl value) {
                    if (value == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/util/table/CssShorthandExpandProcessor$1", "visitValue"));
                    }
                    if (value.isGroup() && !(value instanceof CssReferencePropertyValue)) {
                        for (CssPropertyValue each : value.getChildren()) {
                            String refName = each.getRefName();
                            if (refName == null) continue;
                            String referencedPropertyName = CssShorthandExpandProcessor.this.createName(refName, each.hasImmutablePrefix());
                            CssPropertyDescriptor referencedDescriptor = this.provider != null ? this.provider.getPropertyDescriptor(referencedPropertyName, (PsiElement)decl) : null;
                            if (referencedDescriptor == null) continue;
                            if (referencedDescriptor.isShorthandValue()) {
                                String[] expandedValues;
                                for (String expandedValue : expandedValues = referencedDescriptor.expand(decl)) {
                                    result.put(vendorPrefix + expandedValue, refName);
                                }
                                continue;
                            }
                            result.put(vendorPrefix + referencedPropertyName, refName);
                        }
                    }
                }
            });
        }
        HashMap<String, String> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssShorthandExpandProcessor", "processReferences"));
        }
        return hashMap;
    }

    @NotNull
    private String createName(@NotNull String name, boolean hasImmutablePrefix) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/util/table/CssShorthandExpandProcessor", "createName"));
        }
        String propertyName = this.myDescriptor.getPropertyName();
        int index = name.lastIndexOf(45);
        String string = index == -1 || hasImmutablePrefix ? name : propertyName + name.substring(index);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssShorthandExpandProcessor", "createName"));
        }
        return string;
    }

    private String[] suggestValueNames() {
        String propertyName = this.myDescriptor.getPropertyName();
        String[] strings = propertyName.split("-");
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            StringBuilder builder = new StringBuilder(strings[0]);
            builder.append('-').append(VALUE_4[i]);
            if (strings.length > 1) {
                builder.append('-').append(strings[1]);
            }
            result.add(builder.toString());
        }
        return ArrayUtil.toStringArray(result);
    }
}

