/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.css.inspections.CssConvertColorToRgbInspection;
import java.awt.Color;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CssConvertColorToHexInspection
extends CssConvertColorToRgbInspection {
    private static final LocalQuickFix fix = new LocalQuickFix(){

        @NotNull
        public String getName() {
            String string = CssBundle.message((String)"css.convert.color.value.to.hex", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssConvertColorToHexInspection$1", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = CssBundle.message((String)"css.convert.color.to.hex.family", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssConvertColorToHexInspection$1", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/inspections/CssConvertColorToHexInspection$1", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/inspections/CssConvertColorToHexInspection$1", "applyFix"));
            }
            final PsiElement value = descriptor.getPsiElement();
            if (value == null) {
                return;
            }
            final PsiFile psiFile = value.getContainingFile();
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            new WriteCommandAction(project, new PsiFile[]{psiFile}){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/inspections/CssConvertColorToHexInspection$1$1", "run"));
                    }
                    Color color = CssPsiColorUtil.getColor(value);
                    if (color != null) {
                        value.replace((PsiElement)CssElementFactory.getInstance((Project)project).createTerm(CssPsiColorUtil.toHexColor(color), psiFile.getFileType()));
                    }
                }
            }.execute();
        }
    };

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CssBundle.message((String)"css.inspections.convert.color.to.hex", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssConvertColorToHexInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("CssConvertColorToHexInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssConvertColorToHexInspection", "getShortName"));
        }
        return "CssConvertColorToHexInspection";
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/CssConvertColorToHexInspection", "buildVisitor"));
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssTerm(CssTerm _term) {
                super.visitCssTerm(_term);
                if (CssTermTypes.COLOR == _term.getTermType() && CssConvertColorToRgbInspection.isColorFunction((PsiElement)_term)) {
                    holder.registerProblem((PsiElement)_term, CssBundle.message((String)"css.convert.color.value.to.hex", (Object[])new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{fix});
                }
            }
        };
        if (cssElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/CssConvertColorToHexInspection", "buildVisitor"));
        }
        return cssElementVisitor;
    }
}

