/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInsight.daemon.impl.analysis.DefaultHighlightingSettingProvider;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.index.CssMinifiedFileChecker;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssDefaultHighlightingSettingsProvider
extends DefaultHighlightingSettingProvider
implements DumbAware {
    private boolean enableMinifiedFilesFilterInTests = false;

    @Nullable
    public FileHighlightingSetting getDefaultSetting(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/inspections/CssDefaultHighlightingSettingsProvider", "getDefaultSetting"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/inspections/CssDefaultHighlightingSettingsProvider", "getDefaultSetting"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !this.enableMinifiedFilesFilterInTests) {
            return null;
        }
        if (!file.isValid() || file.getCanonicalPath() == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null || !psiFile.getLanguage().isKindOf(psiFile.getLanguage())) {
            return null;
        }
        return CssDefaultHighlightingSettingsProvider.isMinified(file, psiFile) != false ? FileHighlightingSetting.SKIP_HIGHLIGHTING : null;
    }

    private static Boolean isMinified(final @NotNull VirtualFile file, @NotNull PsiFile psiFile) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/inspections/CssDefaultHighlightingSettingsProvider", "isMinified"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/psi/css/inspections/CssDefaultHighlightingSettingsProvider", "isMinified"));
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiFile, (CachedValueProvider)new CachedValueProvider<Boolean>(){

            @Nullable
            public CachedValueProvider.Result<Boolean> compute() {
                return CachedValueProvider.Result.create((Object)CssMinifiedFileChecker.isMinifiedFile(file), (Object[])new Object[]{file});
            }
        });
    }

    public static void enableMinifiedFilesFilterInTests(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/psi/css/inspections/CssDefaultHighlightingSettingsProvider", "enableMinifiedFilesFilterInTests"));
        }
        final CssDefaultHighlightingSettingsProvider instance = (CssDefaultHighlightingSettingsProvider)((Object)EP_NAME.findExtension(CssDefaultHighlightingSettingsProvider.class));
        if (instance != null) {
            instance.enableMinifiedFilesFilterInTests = true;
            Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

                public void dispose() {
                    instance.enableMinifiedFilesFilterInTests = false;
                }
            });
        }
    }
}

