/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssIdSelector;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.inspections.CssFixFactory;
import com.intellij.psi.css.usages.CssSearchHelper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import java.util.Set;

class CssUnusedSymbolVisitor
extends PsiElementVisitor {
    private final ProblemsHolder myHolder;
    private final boolean myOnTheFly;

    public CssUnusedSymbolVisitor(ProblemsHolder holder, boolean onTheFly) {
        this.myHolder = holder;
        this.myOnTheFly = onTheFly;
    }

    public void visitFile(PsiFile file) {
        boolean nonTrivialInjection;
        boolean fragment = InjectedLanguageManager.getInstance((Project)file.getProject()).isInjectedFragment(file);
        boolean bl = nonTrivialInjection = fragment && file.textContains('\n');
        if (CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)file) && !(file instanceof CssFile) || file instanceof CssFile && (nonTrivialInjection || !this.myOnTheFly && !fragment)) {
            CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)file);
            boolean checkIds = descriptorProvider == null || descriptorProvider.providesClassicCss();
            file.accept((PsiElementVisitor)new MyRecursiveElementVisitor(this.myHolder, this.myOnTheFly, file, checkIds));
        }
    }

    private static class MyRecursiveElementVisitor
    extends PsiRecursiveElementWalkingVisitor {
        private final ProblemsHolder myHolder;
        private final boolean myOnTheFly;
        private final PsiFile myFile;
        private final boolean myCheckIds;

        public MyRecursiveElementVisitor(ProblemsHolder holder, boolean onTheFly, PsiFile file, boolean checkIds) {
            super(false);
            this.myHolder = holder;
            this.myOnTheFly = onTheFly;
            this.myFile = file;
            this.myCheckIds = checkIds;
        }

        public void visitElement(PsiElement element) {
            String text;
            PsiElement grandParent;
            ProgressManager.checkCanceled();
            if ((element instanceof CssClass || element instanceof CssIdSelector && this.myCheckIds) && (grandParent = element.getParent().getParent()).getParent().getLastChild() == grandParent && !(text = element.getText()).isEmpty()) {
                String name;
                Set mediaTypes = CssPsiUtil.getAllowedMediaTypesInContext((PsiElement)element);
                if (!mediaTypes.contains(CssMediaType.SCREEN) && !mediaTypes.contains(CssMediaType.ALL)) {
                    return;
                }
                boolean used = CssSearchHelper.isClassOrIdUsed(element, (SearchScope)(this.myOnTheFly ? new LocalSearchScope((PsiElement)InjectedLanguageManager.getInstance((Project)this.myFile.getProject()).getTopLevelFile((PsiElement)this.myFile)) : GlobalSearchScope.projectScope((Project)element.getProject())));
                if (!used && (name = ((PsiNamedElement)element).getName()) != null) {
                    this.myHolder.registerProblem(element, CssBundle.message((String)"css.inspections.unused.symbol.text", (Object[])new Object[]{name}), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{CssFixFactory.getInstance().removeUnusedSymbolIntentionAction(name)});
                }
            }
            super.visitElement(element);
        }
    }
}

