/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.fixes;

import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssPseudoSelector;
import org.jetbrains.annotations.NotNull;

public class CssReplacePseudoPrefixQuickFix
extends LocalQuickFixBase {
    private final int newLength;

    public CssReplacePseudoPrefixQuickFix(int actualLength, int expectedLength) {
        super(CssBundle.message((String)"css.inspections.invalid.pseudo.prefix.quickfix", (Object[])new Object[]{StringUtil.repeatSymbol((char)':', (int)actualLength), StringUtil.repeatSymbol((char)':', (int)expectedLength)}));
        this.newLength = expectedLength;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/inspections/fixes/CssReplacePseudoPrefixQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/inspections/fixes/CssReplacePseudoPrefixQuickFix", "applyFix"));
        }
        PsiElement pseudoSelector = descriptor.getPsiElement();
        if (this.newLength > 0 && pseudoSelector instanceof CssPseudoSelector) {
            String name = ((CssPseudoSelector)pseudoSelector).getName();
            CssElementFactory elementFactory = CssElementFactory.getInstance((Project)project);
            boolean isEscaped = StringUtil.startsWithChar((CharSequence)pseudoSelector.getText().trim(), (char)'\\');
            CssPseudoSelector newPseudoSelector = elementFactory.createPseudoSelector(StringUtil.repeatSymbol((char)':', (int)this.newLength) + name, pseudoSelector.getContainingFile().getFileType(), isEscaped);
            pseudoSelector.replace((PsiElement)newPseudoSelector);
        }
    }
}

