/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.google.common.collect.Maps;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.css.resolve.UrlReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashMap;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CssUnknownTargetInspection
extends CssBaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CssBundle.message((String)"css.inspections.unknown.target", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/invalid/CssUnknownTargetInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/invalid/CssUnknownTargetInspection", "buildVisitor"));
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssString(CssString string) {
                CssUnknownTargetInspection.processElement((PsiElement)string, holder);
            }

            public void visitCssUri(CssUri uri) {
                PsiElement element = uri.getValueElement();
                if (element != null && !(element instanceof CssString)) {
                    CssUnknownTargetInspection.processElement(element, holder);
                }
            }
        };
        if (cssElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/invalid/CssUnknownTargetInspection", "buildVisitor"));
        }
        return cssElementVisitor;
    }

    private static void processElement(@NotNull PsiElement element, ProblemsHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/inspections/invalid/CssUnknownTargetInspection", "processElement"));
        }
        if (!element.isValid() || PsiTreeUtil.getParentOfType((PsiElement)element, CssFunction.class) == null && PsiTreeUtil.getParentOfType((PsiElement)element, CssImport.class) == null && PsiTreeUtil.getParentOfType((PsiElement)element, CssUri.class) == null || PsiTreeUtil.getChildOfType((PsiElement)element, OuterLanguageElement.class) != null) {
            return;
        }
        boolean resolved = false;
        for (PsiFile file : CssResolveManager.getInstance().resolveFiles(element, holder.getFile())) {
            if (!(file instanceof CssFile)) continue;
            resolved = true;
            break;
        }
        if (!resolved) {
            HashMap unresolvedReferences = Maps.newHashMap();
            for (PsiReference reference : element.getReferences()) {
                PsiElement resolve;
                if (reference instanceof FileReferenceOwner) {
                    PsiFileReference lastFileReference = ((FileReferenceOwner)reference).getLastFileReference();
                    if (lastFileReference == null || lastFileReference.multiResolve(false).length != 0) continue;
                    unresolvedReferences.put(reference.getCanonicalText(), reference);
                    continue;
                }
                if (!(reference instanceof UrlReference) || (resolve = reference.resolve()) != null) continue;
                unresolvedReferences.put(reference.getCanonicalText(), reference);
            }
            for (PsiReference reference : unresolvedReferences.values()) {
                String errorMessage;
                try {
                    errorMessage = ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference);
                }
                catch (IllegalArgumentException e) {
                    errorMessage = ((EmptyResolveMessageProvider)reference).getUnresolvedMessagePattern();
                }
                holder.registerProblem(reference, errorMessage, reference.isSoft() ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
        }
    }
}

