/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.style;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.CssElementType;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class CssRedundantUnitInspection
extends CssBaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = CssBundle.message((String)"css.inspections.redundant.unit", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/style/CssRedundantUnitInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/style/CssRedundantUnitInspection", "buildVisitor"));
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssDeclaration(CssDeclaration cssDeclaration) {
                CssPropertyDescriptor descriptor = cssDeclaration.getDescriptor();
                if (descriptor == null) {
                    return;
                }
                CssTermList termList = cssDeclaration.getValue();
                if (termList == null) {
                    return;
                }
                for (PsiElement element : termList.getChildren()) {
                    IElementType iElementType;
                    PsiElement firstTermElement = element.getFirstChild();
                    if (firstTermElement == null) continue;
                    PsiElement child = firstTermElement.getFirstChild();
                    boolean foundNumberTerm = false;
                    if (child instanceof CssTokenImpl && (iElementType = ((CssTokenImpl)child).getElementType()) == CssElementTypes.CSS_NUMBER) {
                        foundNumberTerm = true;
                    }
                    if (!foundNumberTerm) continue;
                    boolean zeroValue = "0".equals(child.getText());
                    PsiElement nextSibling = child.getNextSibling();
                    if (!zeroValue || nextSibling == null || nextSibling instanceof PsiWhiteSpace) continue;
                    holder.registerProblem(nextSibling, CssBundle.message((String)"css.inspections.redundant.unit.message", (Object[])new Object[]{nextSibling.getText()}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveUnitQualifier()});
                }
            }
        };
        if (cssElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/style/CssRedundantUnitInspection", "buildVisitor"));
        }
        return cssElementVisitor;
    }

    private static class RemoveUnitQualifier
    extends LocalQuickFixBase {
        public RemoveUnitQualifier() {
            super(CssBundle.message((String)"css.inspections.redundant.unit.fix.message", (Object[])new Object[0]));
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/inspections/style/CssRedundantUnitInspection$RemoveUnitQualifier", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/inspections/style/CssRedundantUnitInspection$RemoveUnitQualifier", "applyFix"));
            }
            final PsiElement psiElement = descriptor.getPsiElement();
            if (psiElement != null && psiElement.isValid() && (psiElement instanceof CssElement || psiElement.getNode().getElementType() instanceof CssElementType)) {
                new WriteCommandAction(project, new PsiFile[]{psiElement.getContainingFile()}){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/inspections/style/CssRedundantUnitInspection$RemoveUnitQualifier$1", "run"));
                        }
                        if (psiElement.isValid()) {
                            psiElement.delete();
                        }
                    }
                }.execute();
            }
        }
    }
}

