/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.parameterinfo;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssDescriptorOwner;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssValueOwner;
import com.intellij.psi.css.descriptor.CssValueOwnerDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueDescriptorVisitor;
import com.intellij.psi.css.descriptor.value.CssValueMatchData;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.descriptor.visitor.CssParameterInfoValueDescriptorsVisitor;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssParameterInfoHandler
implements ParameterInfoHandler<CssValueOwner, CssValueOwnerDescriptor> {
    public boolean couldShowInLookup() {
        return false;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Nullable
    public Object[] getParametersForDocumentation(CssValueOwnerDescriptor valueOwnerDescriptor, ParameterInfoContext context) {
        return new CssValueDescriptor[]{valueOwnerDescriptor.getValueDescriptor()};
    }

    public CssValueOwner findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        Collection descriptors;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/parameterinfo/CssParameterInfoHandler", "findElementForParameterInfo"));
        }
        CssValueOwner element = CssParameterInfoHandler.findElement(context.getFile(), context.getOffset());
        if (element != null && element instanceof CssDescriptorOwner && !(descriptors = CssDescriptorsUtil.filterDescriptorsByContext((Collection)((CssDescriptorOwner)element).getDescriptors(), (PsiElement)element)).isEmpty()) {
            context.setItemsToShow(ArrayUtil.toObjectArray((Collection)CssDescriptorsUtil.sortDescriptors((Collection)descriptors)));
        }
        return element;
    }

    public void showParameterInfo(@NotNull CssValueOwner element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/parameterinfo/CssParameterInfoHandler", "showParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/parameterinfo/CssParameterInfoHandler", "showParameterInfo"));
        }
        context.showHint((PsiElement)element, element.getTextOffset() + 1, (ParameterInfoHandler)this);
    }

    public CssValueOwner findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        PsiElement declaration;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/parameterinfo/CssParameterInfoHandler", "findElementForUpdatingParameterInfo"));
        }
        CssValueOwner element = CssParameterInfoHandler.findElement(context.getFile(), context.getOffset());
        if (element != null && ((declaration = context.getParameterOwner()) == null || declaration == element)) {
            return element;
        }
        return null;
    }

    public void updateParameterInfo(@NotNull CssValueOwner valueOwner, @NotNull UpdateParameterInfoContext context) {
        if (valueOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueOwner", "com/intellij/psi/css/parameterinfo/CssParameterInfoHandler", "updateParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/parameterinfo/CssParameterInfoHandler", "updateParameterInfo"));
        }
        if (context.getParameterOwner() == null || valueOwner.equals(context.getParameterOwner())) {
            context.setParameterOwner((PsiElement)valueOwner);
            context.setCurrentParameter(context.getOffset());
        } else {
            context.removeHint();
        }
    }

    public String getParameterCloseChars() {
        return ",){}";
    }

    public boolean tracksParameterIndex() {
        return true;
    }

    public void updateUI(CssValueOwnerDescriptor elementDescriptor, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/parameterinfo/CssParameterInfoHandler", "updateUI"));
        }
        CssParameterInfoHandler.updateUIText(elementDescriptor, context);
    }

    @Nullable
    public static String updateUIText(CssValueOwnerDescriptor elementDescriptor, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/parameterinfo/CssParameterInfoHandler", "updateUIText"));
        }
        PsiElement parameterOwner = context.getParameterOwner();
        CssValueDescriptor highlightingDescriptor = null;
        if (parameterOwner instanceof CssValueOwner) {
            CssValueMatchData deepestNotMatchedData;
            CssValueMatchData matchData;
            CssTermList valueElement = ((CssValueOwner)parameterOwner).getValue();
            if (valueElement != null && (highlightingDescriptor = CssParameterInfoHandler.findHighlightingDescriptor(context, valueElement, matchData = valueElement.matchWithValueDescriptor(elementDescriptor.getValueDescriptor()))) == null && (deepestNotMatchedData = matchData.findDeepestNotMatchedData()) != null) {
                highlightingDescriptor = deepestNotMatchedData.getDescriptor();
            }
            boolean strikeout = elementDescriptor.getValueDescriptor().getObsoleteVersion() != null;
            CssParameterInfoValueDescriptorsVisitor parameterInfoBuilder = new CssParameterInfoValueDescriptorsVisitor(highlightingDescriptor, false, false);
            elementDescriptor.getValueDescriptor().accept((CssValueDescriptorVisitor)parameterInfoBuilder);
            String parameterInfoString = parameterInfoBuilder.getParameterInfo();
            int highlightStartOffset = parameterInfoBuilder.getHighlightingStart();
            int highlightEndOffset = parameterInfoBuilder.getHighlightingEnd();
            return context.setupUIComponentPresentation(parameterInfoString, highlightStartOffset, highlightEndOffset, false, strikeout, false, context.getDefaultParameterColor());
        }
        return null;
    }

    @Nullable
    private static CssValueDescriptor findHighlightingDescriptor(@NotNull ParameterInfoUIContext context, @NotNull CssTermList valueElement, @NotNull CssValueMatchData matchData) {
        PsiElement prevVisibleLeaf;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/parameterinfo/CssParameterInfoHandler", "findHighlightingDescriptor"));
        }
        if (valueElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueElement", "com/intellij/psi/css/parameterinfo/CssParameterInfoHandler", "findHighlightingDescriptor"));
        }
        if (matchData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchData", "com/intellij/psi/css/parameterinfo/CssParameterInfoHandler", "findHighlightingDescriptor"));
        }
        if (context.getCurrentParameterIndex() < 0) {
            return null;
        }
        PsiElement elementAt = valueElement.getContainingFile().findElementAt(context.getCurrentParameterIndex());
        if (elementAt == null) {
            return null;
        }
        ASTNode node = elementAt.getNode();
        if (node == null) {
            return null;
        }
        if (elementAt instanceof PsiWhiteSpace) {
            PsiElement nextVisibleLeaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)elementAt);
            if (nextVisibleLeaf != null && !CssElementTypes.PUNCTUATION.contains(nextVisibleLeaf.getNode().getElementType())) {
                elementAt = nextVisibleLeaf;
            }
        } else if (CssElementTypes.PUNCTUATION.contains(node.getElementType()) && (prevVisibleLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)elementAt)) != null && !CssElementTypes.PUNCTUATION.contains(prevVisibleLeaf.getNode().getElementType())) {
            elementAt = prevVisibleLeaf;
        }
        CssValueDescriptor result = null;
        while (elementAt != null && (result = matchData.findDeepestDescriptorForElement(elementAt)) == null) {
            elementAt = elementAt.getParent();
        }
        return result;
    }

    @Nullable
    private static CssValueOwner findElement(PsiFile file, int offset) {
        PsiElement psiElement = file.findElementAt(offset);
        if (psiElement != null) {
            CssValueOwner valueOwner = (CssValueOwner)PsiTreeUtil.getParentOfType((PsiElement)psiElement, CssValueOwner.class);
            if (valueOwner == null && psiElement instanceof PsiWhiteSpace) {
                PsiElement prevVisibleLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)psiElement);
                return prevVisibleLeaf != null ? CssParameterInfoHandler.findElement(file, prevVisibleLeaf.getTextRange().getStartOffset()) : null;
            }
            if (valueOwner != null) {
                CssValueOwner parentOwner;
                if (!valueOwner.getValueTextRange().containsOffset(offset) && (parentOwner = (CssValueOwner)PsiTreeUtil.getParentOfType((PsiElement)valueOwner, CssValueOwner.class)) != null) {
                    return parentOwner;
                }
                return valueOwner;
            }
            return (CssValueOwner)PsiTreeUtil.getPrevSiblingOfType((PsiElement)psiElement, CssValueOwner.class);
        }
        return null;
    }
}

