/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolvingHint;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssIdSelector;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.reference.TemplateCssClassOrIdReference;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.css.resolve.CssSelectorMatcher;
import com.intellij.psi.css.util.CssCompletionUtil;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiPolyVariantCachingReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ReflectionUtil;
import java.util.HashMap;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class HtmlCssClassOrIdReference
extends PsiPolyVariantCachingReference
implements TemplateCssClassOrIdReference,
ResolvingHint,
EmptyResolveMessageProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.css.impl.util.references.HtmlCssClassOrIdReference");
    private final PsiElement myElement;
    private final int start;
    private final int end;
    private final boolean myCaseSensitive;
    private final boolean mySoft;

    public HtmlCssClassOrIdReference(PsiElement element, int _start, int _end, boolean caseSensitive, boolean soft) {
        this.myElement = element;
        this.start = _start;
        this.end = _end;
        this.myCaseSensitive = caseSensitive;
        this.mySoft = soft;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return new TextRange(this.start, this.end);
    }

    @NotNull
    public String getCanonicalText() {
        String text = this.myElement.getText();
        int _end = this.end > text.length() ? text.length() : this.end;
        String s = text.substring(this.start, _end);
        String string = this.myCaseSensitive ? s : s.toLowerCase(Locale.US);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myElement);
        LOG.assertTrue(manipulator != null);
        return manipulator.handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference", "bindToElement"));
        }
        return null;
    }

    private static boolean isId(PsiElement element) {
        XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class);
        return xmlAttribute != null && HtmlCssClassOrIdReference.isIdAttribute(xmlAttribute);
    }

    public static boolean isIdAttribute(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference", "isIdAttribute"));
        }
        return attribute.getName().toLowerCase(Locale.US).endsWith("id");
    }

    public boolean isReferenceTo(PsiElement element) {
        if (element instanceof CssClass && !HtmlCssClassOrIdReference.isId(this.myElement)) {
            return this.isEqualName(((CssClass)element).getName()) && this.refersToTheSameObject(element);
        }
        if (element instanceof CssIdSelector && HtmlCssClassOrIdReference.isId(this.myElement)) {
            return this.isEqualName(((CssIdSelector)element).getName()) && this.refersToTheSameObject(element);
        }
        return false;
    }

    private boolean isEqualName(String name) {
        String canonicalText = this.getCanonicalText();
        return this.myCaseSensitive && canonicalText.equals(name) || !this.myCaseSensitive && canonicalText.equalsIgnoreCase(name);
    }

    private boolean refersToTheSameObject(PsiElement element) {
        XmlTag referringTag;
        ResolveResult[] resolveResults = this.multiResolve(false);
        PsiFile file = element.getContainingFile();
        if (resolveResults.length == 0 && (referringTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlTag.class)) != null) {
            CssResolver resolver = this.getCssResolver();
            resolver.setCareAboutClasses(true);
            resolver.setSelectorMatcher(new CssSelectorMatcher(){

                public boolean isMatch(@NotNull CssSelector selector, @NotNull XmlTag tag, @NotNull CssResolver resolver) {
                    if (selector == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference$1", "isMatch"));
                    }
                    if (tag == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference$1", "isMatch"));
                    }
                    if (resolver == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference$1", "isMatch"));
                    }
                    HashMap mapping = new HashMap();
                    if (!selector.isMatch(tag, resolver, mapping)) {
                        return false;
                    }
                    CssSimpleSelector simpleSelector = (CssSimpleSelector)mapping.get(referringTag);
                    return simpleSelector != null && HtmlCssClassOrIdReference.this.containsRelatedClassOrId(simpleSelector);
                }
            });
            for (XmlTag subTag : referringTag.getSubTags()) {
                if (!HtmlCssClassOrIdReference.tryToResolveTagOrChildrenToFile(subTag, resolver, file)) continue;
                return true;
            }
        }
        for (ResolveResult result : resolveResults) {
            PsiElement referenceElement = result.getElement();
            if (referenceElement == null || referenceElement.getContainingFile() != file) continue;
            return true;
        }
        return false;
    }

    private static boolean tryToResolveTagOrChildrenToFile(XmlTag tag, CssResolver resolver, PsiFile targetFile) {
        CssRuleset[] rulesets;
        for (CssRuleset cssRuleset : rulesets = resolver.resolveAllRulesetsForTag(tag)) {
            if (cssRuleset.getContainingFile() != targetFile) continue;
            return true;
        }
        for (CssRuleset cssRuleset : tag.getSubTags()) {
            if (!HtmlCssClassOrIdReference.tryToResolveTagOrChildrenToFile((XmlTag)cssRuleset, resolver, targetFile)) continue;
            return true;
        }
        return false;
    }

    private boolean containsRelatedClassOrId(CssSimpleSelector selector) {
        boolean isId = HtmlCssClassOrIdReference.isId(this.myElement);
        for (CssSelectorSuffix suffix : selector.getSelectorSuffixes()) {
            String name = suffix.getName();
            if (!(isId ? suffix instanceof CssIdSelector && this.isEqualName(name) : suffix instanceof CssClass && this.isEqualName(name))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        MyClassCandidatesProcessor processor = new MyClassCandidatesProcessor();
        processor.process(false);
        Object[] objectArray = processor.declarations.values().toArray(new Object[processor.declarations.size()]);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference", "getVariants"));
        }
        return objectArray;
    }

    public boolean isSoft() {
        return this.mySoft;
    }

    @NotNull
    protected ResolveResult[] resolveInner(boolean incomplete, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference", "resolveInner"));
        }
        MyClassResolveProcessor processor = new MyClassResolveProcessor();
        processor.process(true);
        if (processor.results != null) {
            ResolveResult[] resolveResultArray = processor.results.values().toArray(new ResolveResult[processor.results.size()]);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference", "resolveInner"));
            }
            return resolveResultArray;
        }
        if (processor.result != null) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{processor.result};
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference", "resolveInner"));
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference", "resolveInner"));
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public boolean canResolveTo(Class<? extends PsiElement> elementClass) {
        return ReflectionUtil.isAssignable(CssClass.class, elementClass) || ReflectionUtil.isAssignable(CssIdSelector.class, elementClass);
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = CssBundle.message((String)"invalid.css.selector", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    protected CssResolver getCssResolver() {
        return CssResolveManager.getInstance().getNewResolver();
    }

    protected XmlAttribute getContextAttribute() {
        return (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlAttribute.class);
    }

    protected XmlTag getContextTag() {
        return (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlTag.class);
    }

    private abstract class MyPsiElementProcessor {
        protected boolean caseInsensitive;
        protected CssResolver newResolver;

        private MyPsiElementProcessor() {
        }

        void process(boolean careAboutClasses) {
            XmlTag xmlTag = HtmlCssClassOrIdReference.this.getContextTag();
            if (xmlTag == null) {
                return;
            }
            this.caseInsensitive = !HtmlCssClassOrIdReference.this.myCaseSensitive;
            XmlAttribute attribute = HtmlCssClassOrIdReference.this.getContextAttribute();
            this.newResolver = HtmlCssClassOrIdReference.this.getCssResolver();
            this.newResolver.setResolvedAttrName(attribute != null ? attribute.getName() : null);
            this.newResolver.setCareAboutClasses(careAboutClasses);
            String lowerAttrName = attribute != null ? attribute.getName().toLowerCase(Locale.US) : null;
            CssSelectorSuffixType targetType = lowerAttrName == null || lowerAttrName.contains("class") || lowerAttrName.contains("stylename") ? CssSelectorSuffixType.CLASS : CssSelectorSuffixType.ID;
            for (CssRuleset cssRuleset : this.newResolver.resolveAllRulesetsForTag(xmlTag)) {
                for (CssSelector selector : cssRuleset.getSelectors()) {
                    for (CssSimpleSelector simpleSelector : selector.getSimpleSelectors()) {
                        for (CssSelectorSuffix selectorSuffix : simpleSelector.getSelectorSuffixes()) {
                            if (targetType != selectorSuffix.getType()) continue;
                            this.handleSelector(selectorSuffix);
                        }
                    }
                }
            }
        }

        abstract boolean handleSelector(CssSelectorSuffix var1);
    }

    private class MyClassCandidatesProcessor
    extends MyPsiElementProcessor {
        final HashMap<String, Object> declarations = new HashMap(3);
        private XmlTag myTag;

        private MyClassCandidatesProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean handleSelector(@NotNull CssSelectorSuffix selectorSuffix) {
            if (selectorSuffix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorSuffix", "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference$MyClassCandidatesProcessor", "handleSelector"));
            }
            String name = selectorSuffix.getName();
            if (!this.declarations.containsKey(name)) {
                boolean careAboutClassesOldValue = this.newResolver.isCareAboutClasses();
                try {
                    String elementName;
                    if (this.myTag == null) {
                        this.myTag = HtmlCssClassOrIdReference.this.getContextTag();
                    }
                    this.newResolver.setCareAboutClasses(true);
                    CssSimpleSelector selector = (CssSimpleSelector)PsiTreeUtil.getParentOfType((PsiElement)selectorSuffix, CssSimpleSelector.class);
                    if (selector != null && !(elementName = selector.getElementName()).isEmpty() && Comparing.strEqual((String)this.myTag.getName(), (String)elementName, (!this.caseInsensitive ? 1 : 0) != 0)) {
                        this.declarations.put(name, CssCompletionUtil.lookupForSelectorSuffix(name, selectorSuffix, this.myTag.getContainingFile()));
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    this.newResolver.setCareAboutClasses(careAboutClassesOldValue);
                }
                this.declarations.put(name, CssCompletionUtil.lookupForSelectorSuffix(name, selectorSuffix, null));
            }
            return true;
        }
    }

    private class MyClassResolveProcessor
    extends MyPsiElementProcessor {
        final String myReferenceText;
        ResolveResult result;
        HashMap<PsiElement, ResolveResult> results;

        MyClassResolveProcessor() {
            this.myReferenceText = HtmlCssClassOrIdReference.this.getCanonicalText();
        }

        @Override
        boolean handleSelector(@NotNull CssSelectorSuffix selectorSuffix) {
            PsiElement element;
            if (selectorSuffix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorSuffix", "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference$MyClassResolveProcessor", "handleSelector"));
            }
            if (this.results != null && this.results.containsKey(selectorSuffix)) {
                return true;
            }
            if (this.result != null && (element = this.result.getElement()) != null && element.isEquivalentTo((PsiElement)selectorSuffix)) {
                return true;
            }
            if (Comparing.strEqual((String)this.myReferenceText, (String)selectorSuffix.getName(), (!this.caseInsensitive ? 1 : 0) != 0)) {
                if (this.result != null) {
                    this.results = new HashMap(3);
                    this.results.put(this.result.getElement(), this.result);
                    this.result = null;
                }
                if (this.results == null) {
                    this.result = new PsiElementResolveResult((PsiElement)selectorSuffix);
                } else {
                    this.results.put((PsiElement)selectorSuffix, (ResolveResult)new PsiElementResolveResult((PsiElement)selectorSuffix));
                }
                return true;
            }
            return true;
        }
    }
}

