/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.usages;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.usages.CssClassOrIdUsagesProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import org.jetbrains.annotations.NotNull;

public class CssSearchHelper {
    private CssSearchHelper() {
    }

    public static boolean isClassOrIdUsed(@NotNull PsiElement element, @NotNull SearchScope scope) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/usages/CssSearchHelper", "isClassOrIdUsed"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/css/usages/CssSearchHelper", "isClassOrIdUsed"));
        }
        return CssSearchHelper.isUsed(element, scope);
    }

    private static boolean isUsed(final @NotNull PsiElement element, @NotNull SearchScope scope) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/usages/CssSearchHelper", "isUsed"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/css/usages/CssSearchHelper", "isUsed"));
        }
        if (element.isValid()) {
            final boolean[] used = new boolean[]{false};
            Project project = element.getProject();
            String text = element.getText();
            if (text.length() > 1) {
                String cssClassOrIdName = element.getText().substring(1);
                PsiSearchHelper searchHelper = PsiSearchHelper.SERVICE.getInstance((Project)project);
                PsiFile file = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile(element);
                FileViewProvider viewProvider = file.getViewProvider();
                file = viewProvider.getPsi(viewProvider.getBaseLanguage());
                if (scope instanceof GlobalSearchScope && searchHelper.isCheapEnoughToSearch(cssClassOrIdName, (GlobalSearchScope)scope, file, ProgressManager.getInstance().getProgressIndicator()) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                    return true;
                }
                searchHelper.processElementsWithWord(new TextOccurenceProcessor(){

                    public boolean execute(@NotNull PsiElement current, int offsetInElement) {
                        if (current == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/psi/css/usages/CssSearchHelper$1", "execute"));
                        }
                        ProgressManager.checkCanceled();
                        if (used[0]) {
                            return false;
                        }
                        if (current instanceof CssTokenImpl) {
                            return true;
                        }
                        for (CssClassOrIdUsagesProvider usagesProvider : (CssClassOrIdUsagesProvider[])CssClassOrIdUsagesProvider.EXTENSION_POINT_NAME.getExtensions()) {
                            if (!usagesProvider.isUsage(element, current, offsetInElement)) continue;
                            used[0] = true;
                            return false;
                        }
                        return true;
                    }
                }, scope, cssClassOrIdName, (short)11, false);
                return used[0];
            }
        }
        return true;
    }
}

