/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.util;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssCompletionUtil {
    public static final int CSS_SELECTOR_SUFFIX_PRIORITY = 20;
    public static final int CSS_SELECTOR_SUFFIX_FROM_HTML_PRIORITY = 10;
    public static final int CSS_KEYWORDS_PRIORITY = 20;

    @NotNull
    public static LookupElement lookupForSelectorSuffix(@NotNull String name, @NotNull CssSelectorSuffix selectorSuffix, @Nullable PsiFile contextFile) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffix"));
        }
        if (selectorSuffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorSuffix", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffix"));
        }
        LookupElementBuilder builder = LookupElementBuilder.createWithSmartPointer((String)name, (PsiElement)selectorSuffix).withCaseSensitivity(false);
        int priority = 20;
        if (contextFile == selectorSuffix.getContainingFile()) {
            priority += 10;
        }
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)builder.withIcon(selectorSuffix.getIcon(0)), (double)priority);
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffix"));
        }
        return lookupElement;
    }

    @NotNull
    public static LookupElement lookupForSelectorSuffixFromHtml(@NotNull String name, @NotNull CssSelectorSuffixType type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffixFromHtml"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffixFromHtml"));
        }
        LookupElement lookupElement = CssCompletionUtil.lookupForSelectorSuffixFromHtml(name, type, 0);
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffixFromHtml"));
        }
        return lookupElement;
    }

    @NotNull
    public static LookupElement lookupForSelectorSuffixFromHtml(@NotNull String name, @NotNull CssSelectorSuffixType type, int extraPriority) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffixFromHtml"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffixFromHtml"));
        }
        LookupElementBuilder builder = LookupElementBuilder.create((String)name).withIcon(type.getIcon()).withTypeText("from html").withCaseSensitivity(false);
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)builder, (double)(10 + extraPriority));
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForSelectorSuffixFromHtml"));
        }
        return lookupElement;
    }

    public static LookupElement lookupForKeyword(@NotNull String lookupString) {
        if (lookupString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupString", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForKeyword"));
        }
        return CssCompletionUtil.lookupForKeyword(lookupString, null);
    }

    public static LookupElement lookupForKeyword(@NotNull String lookupString, @Nullable InsertHandler<LookupElement> insertHandler) {
        if (lookupString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupString", "com/intellij/psi/css/util/CssCompletionUtil", "lookupForKeyword"));
        }
        LookupElementBuilder builder = LookupElementBuilder.create((String)lookupString).bold().withInsertHandler(insertHandler);
        return PrioritizedLookupElement.withPriority((LookupElement)builder, (double)20.0);
    }
}

