/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.util;

import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.index.CssSupportedFileTypesProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CssFileTypeUtil {
    @NotNull
    public static String[] getAllCssExtensions() {
        ArrayList supportedExtensions = ContainerUtil.newArrayList();
        CssFileTypeUtil.addFileTypeExtensionsToCollection(supportedExtensions, (FileType)CssFileType.INSTANCE);
        for (CssSupportedFileTypesProvider provider : (CssSupportedFileTypesProvider[])CssSupportedFileTypesProvider.EP_NAME.getExtensions()) {
            CssFileTypeUtil.addFileTypeExtensionsToCollection(supportedExtensions, (FileType)provider.getSupportedFileType());
        }
        String[] stringArray = supportedExtensions.toArray(new String[supportedExtensions.size()]);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/CssFileTypeUtil", "getAllCssExtensions"));
        }
        return stringArray;
    }

    private static void addFileTypeExtensionsToCollection(@NotNull Collection<String> extensions, @NotNull FileType fileType) {
        if (extensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "com/intellij/psi/css/util/CssFileTypeUtil", "addFileTypeExtensionsToCollection"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/css/util/CssFileTypeUtil", "addFileTypeExtensionsToCollection"));
        }
        List associations = FileTypeManager.getInstance().getAssociations(fileType);
        for (FileNameMatcher association : associations) {
            if (!(association instanceof ExtensionFileNameMatcher)) continue;
            extensions.add(((ExtensionFileNameMatcher)association).getExtension());
        }
    }
}

