/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class SpringBootModelConfigFileContributor {
    public static final ExtensionPointName<SpringBootModelConfigFileContributor> EP_NAME = ExtensionPointName.create((String)"com.intellij.spring.boot.modelConfigFileContributor");
    private final FileType myFileType;

    protected SpringBootModelConfigFileContributor(FileType fileType) {
        this.myFileType = fileType;
    }

    public List<VirtualFile> getConfigurationFiles(Module module) {
        SmartList allConfigFiles = new SmartList();
        allConfigFiles.addAll(this.findApplicationConfigFiles(module, "application"));
        allConfigFiles.addAll(this.findApplicationConfigFiles(module, "bootstrap"));
        return allConfigFiles;
    }

    private List<VirtualFile> findApplicationConfigFiles(Module module, String baseName) {
        VirtualFile configFile = this.findSingleConfigFile(module, baseName);
        if (configFile == null) {
            return Collections.emptyList();
        }
        return this.collectProfileConfigs(module, configFile);
    }

    @Nullable
    private VirtualFile findSingleConfigFile(Module module, final String fileNameWithoutExtension) {
        GlobalSearchScope moduleScope = module.getModuleScope(false);
        Collection allFiles = FileTypeIndex.getFiles((FileType)this.myFileType, (GlobalSearchScope)moduleScope);
        List matchingFiles = ContainerUtil.filter((Collection)allFiles, (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                return Comparing.equal((String)fileNameWithoutExtension, (String)file.getNameWithoutExtension());
            }
        });
        return matchingFiles.size() == 1 ? (VirtualFile)ContainerUtil.getFirstItem((List)matchingFiles) : null;
    }

    private List<VirtualFile> collectProfileConfigs(Module module, VirtualFile configFile) {
        SmartList result = new SmartList((Object)configFile);
        VirtualFile parentDirectory = configFile.getParent();
        if (parentDirectory == null) {
            return result;
        }
        final String fileNamePrefix = configFile.getNameWithoutExtension() + '-';
        Project project = module.getProject();
        GlobalSearchScope directoryScope = GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)parentDirectory, (boolean)false);
        Collection allByTypeInDirectory = FileTypeIndex.getFiles((FileType)this.myFileType, (GlobalSearchScope)directoryScope);
        result.addAll(ContainerUtil.filter((Collection)allByTypeInDirectory, (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                return StringUtil.startsWith((CharSequence)file.getNameWithoutExtension(), (CharSequence)fileNamePrefix);
            }
        }));
        return result;
    }
}

