/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.facet;

import com.intellij.openapi.application.Application;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;

public class OsmorcFacetRefactoringListenerProvider
implements RefactoringElementListenerProvider {
    private final Application myApplication;

    public OsmorcFacetRefactoringListenerProvider(Application application) {
        this.myApplication = application;
    }

    @Nullable
    public RefactoringElementListener getListener(PsiElement element) {
        OsmorcFacet osmorcFacet;
        if (element instanceof PsiClass && (osmorcFacet = OsmorcFacet.getInstance(element)) != null) {
            OsmorcFacetConfiguration osmorcFacetConfiguration = (OsmorcFacetConfiguration)osmorcFacet.getConfiguration();
            PsiClass psiClass = (PsiClass)element;
            if (osmorcFacetConfiguration.isOsmorcControlsManifest() && osmorcFacetConfiguration.getBundleActivator() != null && osmorcFacetConfiguration.getBundleActivator().equals(psiClass.getQualifiedName())) {
                return new ActivatorClassRefactoringListener(osmorcFacetConfiguration, this.myApplication);
            }
        }
        return null;
    }

    private static final class ActivatorClassRefactoringListener
    extends RefactoringElementAdapter {
        private final OsmorcFacetConfiguration osmorcFacetConfiguration;
        private final Application application;

        private ActivatorClassRefactoringListener(OsmorcFacetConfiguration osmorcFacetConfiguration, Application application) {
            this.osmorcFacetConfiguration = osmorcFacetConfiguration;
            this.application = application;
        }

        public void elementRenamedOrMoved(final @NotNull PsiElement newElement) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/osmorc/facet/OsmorcFacetRefactoringListenerProvider$ActivatorClassRefactoringListener", "elementRenamedOrMoved"));
            }
            this.application.runWriteAction(new Runnable(){

                @Override
                public void run() {
                    ActivatorClassRefactoringListener.this.osmorcFacetConfiguration.setBundleActivator(((PsiClass)newElement).getQualifiedName());
                }
            });
        }

        public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, final @NotNull String oldQualifiedName) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/osmorc/facet/OsmorcFacetRefactoringListenerProvider$ActivatorClassRefactoringListener", "undoElementMovedOrRenamed"));
            }
            if (oldQualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "org/osmorc/facet/OsmorcFacetRefactoringListenerProvider$ActivatorClassRefactoringListener", "undoElementMovedOrRenamed"));
            }
            this.application.runWriteAction(new Runnable(){

                @Override
                public void run() {
                    ActivatorClassRefactoringListener.this.osmorcFacetConfiguration.setBundleActivator(oldQualifiedName);
                }
            });
        }
    }
}

