/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.facet.ui;

import com.intellij.CommonBundle;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.osgi.jps.model.OutputPathType;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.facet.ui.AdditionalJARContentsTableModel;
import org.osmorc.facet.ui.FileSelectorTableCellEditor;
import org.osmorc.facet.ui.OsmorcFacetGeneralEditorTab;
import org.osmorc.i18n.OsmorcBundle;

public class OsmorcFacetJAREditorTab
extends FacetEditorTab {
    private JPanel myRoot;
    private JTable myAdditionalJARContentsTable;
    private EditorTextField myIgnoreFilePatternTextField;
    private JCheckBox myAlwaysRebuildBundleJARCheckBox;
    private JLabel myFileIgnorePatternLabel;
    private JPanel myIgnoreFilePatternPanel;
    private JTextField myJarFileTextField;
    private JRadioButton myPlaceInCompilerOutputPathRadioButton;
    private JRadioButton myPlaceInProjectWideRadioButton;
    private JRadioButton myPlaceInThisPathRadioButton;
    private TextFieldWithBrowseButton myJarOutputPathChooser;
    private JPanel myAdditionalJarContentsPanel;
    private final FacetEditorContext myEditorContext;
    private final FacetValidatorsManager myValidatorsManager;
    private final AdditionalJARContentsTableModel myAdditionalJARContentsTableModel;
    private boolean myModified;

    public OsmorcFacetJAREditorTab(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager) {
        this.myEditorContext = editorContext;
        this.myValidatorsManager = validatorsManager;
        this.$$$setupUI$$$();
        Project project = editorContext.getProject();
        this.myIgnoreFilePatternTextField = new EditorTextField("", project, (FileType)FileTypes.PLAIN_TEXT);
        FileType type = FileTypeManager.getInstance().getFileTypeByFileName("*.regexp");
        if (type == FileTypes.UNKNOWN) {
            type = FileTypeManager.getInstance().getFileTypeByFileName("*.txt");
        }
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText("*.regexp", type, (CharSequence)this.myIgnoreFilePatternTextField.getText(), -1L, true);
        this.myIgnoreFilePatternTextField.setNewDocumentAndFileType(type, PsiDocumentManager.getInstance((Project)project).getDocument(file));
        this.myIgnoreFilePatternPanel.add((Component)this.myIgnoreFilePatternTextField, "Center");
        UserActivityWatcher watcher = new UserActivityWatcher();
        watcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                OsmorcFacetJAREditorTab.this.myModified = true;
                OsmorcFacetJAREditorTab.this.updateGui();
            }
        });
        watcher.register((Component)this.myRoot);
        this.myJarOutputPathChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OsmorcFacetJAREditorTab.this.onOutputPathSelect();
            }
        });
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                OsmorcFacetJAREditorTab.this.updateGui();
            }
        };
        this.myPlaceInProjectWideRadioButton.addChangeListener(listener);
        this.myPlaceInThisPathRadioButton.addChangeListener(listener);
        this.myPlaceInCompilerOutputPathRadioButton.addChangeListener(listener);
        this.myAdditionalJARContentsTableModel = new AdditionalJARContentsTableModel();
        this.myAdditionalJARContentsTable = new JBTable((TableModel)this.myAdditionalJARContentsTableModel);
        TableColumn col = this.myAdditionalJARContentsTable.getColumnModel().getColumn(0);
        FileSelectorTableCellEditor selectorTableCellEditor = new FileSelectorTableCellEditor(project, this.myEditorContext.getModule());
        col.setCellEditor((TableCellEditor)((Object)selectorTableCellEditor));
        selectorTableCellEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent e) {
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                int row = OsmorcFacetJAREditorTab.this.myAdditionalJARContentsTable.getSelectedRow();
                if (row > -1) {
                    Pair<String, String> additionalJARContent = OsmorcFacetJAREditorTab.this.myAdditionalJARContentsTableModel.getAdditionalJARContent(row);
                    VirtualFile preselectedPath = LocalFileSystem.getInstance().findFileByPath((String)additionalJARContent.getFirst());
                    String destinationName = preselectedPath != null ? OsmorcFacetJAREditorTab.this.determineMostLikelyLocationInJar(preselectedPath) : "";
                    OsmorcFacetJAREditorTab.this.myAdditionalJARContentsTableModel.changeAdditionalJARConent(row, (String)additionalJARContent.first, destinationName);
                    OsmorcFacetJAREditorTab.this.myAdditionalJARContentsTable.editCellAt(row, 1);
                    OsmorcFacetJAREditorTab.this.myAdditionalJARContentsTable.getEditorComponent().requestFocus();
                }
            }
        });
        this.myAdditionalJarContentsPanel.add((Component)ToolbarDecorator.createDecorator((JTable)this.myAdditionalJARContentsTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                OsmorcFacetJAREditorTab.this.onAddAdditionalJarContent();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                OsmorcFacetJAREditorTab.this.onRemoveAdditionalJarContent();
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                OsmorcFacetJAREditorTab.this.onEditAdditionalJARContent();
            }
        }).disableUpDownActions().createPanel(), "Center");
        this.myValidatorsManager.registerValidator(new FacetEditorValidator(){

            @NotNull
            public ValidationResult check() {
                if (StringUtil.isEmptyOrSpaces((String)OsmorcFacetJAREditorTab.this.myJarFileTextField.getText())) {
                    ValidationResult validationResult = new ValidationResult(OsmorcBundle.message("facet.editor.jar.empty.jar.name", new Object[0]));
                    if (validationResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/facet/ui/OsmorcFacetJAREditorTab$8", "check"));
                    }
                    return validationResult;
                }
                if (OsmorcFacetJAREditorTab.this.getSelectedOutputPathType() == OutputPathType.SpecificOutputPath && StringUtil.isEmptyOrSpaces((String)OsmorcFacetJAREditorTab.this.myJarOutputPathChooser.getText())) {
                    ValidationResult validationResult = new ValidationResult(OsmorcBundle.message("facet.editor.jar.empty.output.path", new Object[0]));
                    if (validationResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/facet/ui/OsmorcFacetJAREditorTab$8", "check"));
                    }
                    return validationResult;
                }
                ValidationResult validationResult = ValidationResult.OK;
                if (validationResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/facet/ui/OsmorcFacetJAREditorTab$8", "check"));
                }
                return validationResult;
            }
        }, new JComponent[0]);
    }

    private void onEditAdditionalJARContent() {
        int row = this.myAdditionalJARContentsTable.getSelectedRow();
        if (row > -1) {
            VirtualFile[] files;
            Pair<String, String> additionalJARContent = this.myAdditionalJARContentsTableModel.getAdditionalJARContent(row);
            Project project = this.myEditorContext.getProject();
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor().withTitle(OsmorcBundle.message("facet.editor.select.source.title", new Object[0]));
            VirtualFile preselectedPath = LocalFileSystem.getInstance().findFileByPath((String)additionalJARContent.getFirst());
            if (preselectedPath == null) {
                Module module = this.myEditorContext.getModule();
                VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
                if (contentRoots.length > 0) {
                    for (VirtualFile contentRoot : contentRoots) {
                        VirtualFile path = VfsUtilCore.findRelativeFile((String)((String)additionalJARContent.getFirst()), (VirtualFile)contentRoot);
                        if (path == null) continue;
                        preselectedPath = path;
                        break;
                    }
                    if (preselectedPath == null) {
                        preselectedPath = contentRoots[0];
                    }
                } else if (project.getBaseDir() != null) {
                    preselectedPath = project.getBaseDir();
                }
            }
            if ((files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)preselectedPath)).length > 0) {
                String sourcePath = files[0].getPath();
                String destPath = this.determineMostLikelyLocationInJar(files[0]);
                this.myAdditionalJARContentsTableModel.changeAdditionalJARConent(row, sourcePath, destPath);
                this.myAdditionalJARContentsTable.editCellAt(row, 1);
                this.myAdditionalJARContentsTable.getEditorComponent().requestFocus();
            }
        }
    }

    private void onRemoveAdditionalJarContent() {
        int row = this.myAdditionalJARContentsTable.getSelectedRow();
        int editingCol = this.myAdditionalJARContentsTable.getEditingColumn();
        int editingRow = this.myAdditionalJARContentsTable.getEditingRow();
        if (editingCol != -1 && editingRow != -1) {
            TableCellEditor editor = this.myAdditionalJARContentsTable.getCellEditor(editingRow, editingCol);
            editor.cancelCellEditing();
        }
        this.myAdditionalJARContentsTableModel.deleteAdditionalJARContent(row);
    }

    private void onAddAdditionalJarContent() {
        VirtualFile[] files;
        Project project = this.myEditorContext.getProject();
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createAllButJarContentsDescriptor().withTitle(OsmorcBundle.message("facet.editor.select.source.title", new Object[0]));
        VirtualFile rootFolder = null;
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)this.myEditorContext.getModule()).getContentRoots();
        if (contentRoots.length > 0) {
            rootFolder = contentRoots[0];
        } else if (project.getBaseDir() != null) {
            rootFolder = project.getBaseDir();
        }
        for (VirtualFile file : files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)rootFolder)) {
            String destFile = this.determineMostLikelyLocationInJar(file);
            int row = this.myAdditionalJARContentsTableModel.addAdditionalJARContent(file.getPath(), destFile);
            this.myAdditionalJARContentsTable.editCellAt(row, 1);
            this.myAdditionalJARContentsTable.getEditorComponent().requestFocus();
        }
    }

    private String determineMostLikelyLocationInJar(@NotNull VirtualFile file) {
        VirtualFile[] contentRoots;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/osmorc/facet/ui/OsmorcFacetJAREditorTab", "determineMostLikelyLocationInJar"));
        }
        for (VirtualFile contentRoot : contentRoots = ModuleRootManager.getInstance((Module)this.myEditorContext.getModule()).getContentRoots()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)file, (boolean)false)) continue;
            return VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)contentRoot);
        }
        VirtualFile projectBaseFolder = this.myEditorContext.getProject().getBaseDir();
        if (projectBaseFolder != null && VfsUtilCore.isAncestor((VirtualFile)projectBaseFolder, (VirtualFile)file, (boolean)false)) {
            return VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)projectBaseFolder);
        }
        return file.getName();
    }

    private void updateGui() {
        this.myJarOutputPathChooser.setEnabled(this.myPlaceInThisPathRadioButton.isSelected());
        Boolean bnd = (Boolean)this.myEditorContext.getUserData(OsmorcFacetGeneralEditorTab.BND_CREATION_KEY);
        Boolean bundlor = (Boolean)this.myEditorContext.getUserData(OsmorcFacetGeneralEditorTab.BUNDLOR_CREATION_KEY);
        boolean useExternalTool = Boolean.TRUE.equals(bnd) || Boolean.TRUE.equals(bundlor);
        this.myAdditionalJARContentsTable.setEnabled(!useExternalTool);
        this.myAdditionalJarContentsPanel.setEnabled(!useExternalTool);
        this.myIgnoreFilePatternTextField.setEnabled(!useExternalTool);
        this.myFileIgnorePatternLabel.setEnabled(!useExternalTool);
        this.myValidatorsManager.validate();
    }

    private void onOutputPathSelect() {
        String current = this.myJarOutputPathChooser.getText();
        final VirtualFile moduleOutputDir = CompilerPaths.getModuleOutputDirectory((Module)this.myEditorContext.getModule(), (boolean)false);
        VirtualFile toSelect = StringUtil.isNotEmpty((String)current) ? LocalFileSystem.getInstance().findFileByPath(current) : moduleOutputDir;
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(OsmorcBundle.message("facet.editor.select.bundle.dir.title", new Object[0]));
        FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)this.myEditorContext.getProject(), (VirtualFile)toSelect, (Consumer)new Consumer<VirtualFile>(){

            public void consume(VirtualFile file) {
                if (moduleOutputDir != null && VfsUtilCore.isAncestor((VirtualFile)moduleOutputDir, (VirtualFile)file, (boolean)false)) {
                    Messages.showErrorDialog((Component)OsmorcFacetJAREditorTab.this.myRoot, (String)OsmorcBundle.message("facet.editor.jar.cannot.be.in.output.path", new Object[0]), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]));
                    OsmorcFacetJAREditorTab.this.myJarOutputPathChooser.setText("");
                } else {
                    OsmorcFacetJAREditorTab.this.myJarOutputPathChooser.setText(file.getPath());
                }
            }
        });
    }

    @Nls
    public String getDisplayName() {
        return "Bundle .jar";
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.myRoot;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/facet/ui/OsmorcFacetJAREditorTab", "createComponent"));
        }
        return jPanel;
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void apply() throws ConfigurationException {
        String jarFileName = this.myJarFileTextField.getText();
        if (StringUtil.isEmptyOrSpaces((String)jarFileName)) {
            throw new ConfigurationException(OsmorcBundle.message("facet.editor.jar.empty.jar.name", new Object[0]));
        }
        OsmorcFacetConfiguration configuration = (OsmorcFacetConfiguration)this.myEditorContext.getFacet().getConfiguration();
        OutputPathType pathType = this.getSelectedOutputPathType();
        if (pathType == OutputPathType.SpecificOutputPath) {
            String location = this.myJarOutputPathChooser.getText();
            if (StringUtil.isEmptyOrSpaces((String)location)) {
                throw new ConfigurationException(OsmorcBundle.message("facet.editor.jar.empty.output.path", new Object[0]));
            }
            String completeOutputPath = new File(location, jarFileName).getPath();
            configuration.setJarFileLocation(completeOutputPath, pathType);
        } else {
            configuration.setJarFileLocation(jarFileName, pathType);
        }
        configuration.setIgnoreFilePattern(this.myIgnoreFilePatternTextField.getText());
        configuration.setAlwaysRebuildBundleJAR(this.myAlwaysRebuildBundleJARCheckBox.isSelected());
        configuration.setAdditionalJARContents(this.myAdditionalJARContentsTableModel.getAdditionalContents());
        this.myModified = false;
    }

    public void reset() {
        OsmorcFacetConfiguration configuration = (OsmorcFacetConfiguration)this.myEditorContext.getFacet().getConfiguration();
        OutputPathType outputPathType = configuration.getOutputPathType();
        this.myPlaceInCompilerOutputPathRadioButton.setSelected(outputPathType == OutputPathType.CompilerOutputPath);
        this.myPlaceInProjectWideRadioButton.setSelected(outputPathType == OutputPathType.OsgiOutputPath);
        this.myPlaceInThisPathRadioButton.setSelected(outputPathType == OutputPathType.SpecificOutputPath);
        this.myJarFileTextField.setText(configuration.getJarFileName());
        if (outputPathType == OutputPathType.SpecificOutputPath) {
            this.myJarOutputPathChooser.setText(configuration.getJarFilePath());
        } else {
            this.myJarOutputPathChooser.setText("");
        }
        this.myAdditionalJARContentsTableModel.replaceContent(configuration.getAdditionalJARContents());
        this.myIgnoreFilePatternTextField.setText(configuration.getIgnoreFilePattern());
        this.myAlwaysRebuildBundleJARCheckBox.setSelected(configuration.isAlwaysRebuildBundleJAR());
        this.updateGui();
        this.myModified = false;
    }

    public void onTabEntering() {
        this.updateGui();
    }

    public void disposeUIResources() {
    }

    public String getHelpTopic() {
        return "reference.settings.module.facet.osgi";
    }

    private OutputPathType getSelectedOutputPathType() {
        return this.myPlaceInProjectWideRadioButton.isSelected() ? OutputPathType.OsgiOutputPath : (this.myPlaceInCompilerOutputPathRadioButton.isSelected() ? OutputPathType.CompilerOutputPath : OutputPathType.SpecificOutputPath);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        JLabel jLabel;
        JPanel jPanel2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JTextField jTextField;
        JCheckBox jCheckBox;
        JPanel jPanel3;
        this.myRoot = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Jar file name:");
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAlwaysRebuildBundleJARCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Always rebuild bundle .jar");
        jPanel3.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myJarFileTextField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Jar output path:");
        jPanel3.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPlaceInCompilerOutputPathRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Place in module's output path");
        jPanel3.add((Component)jRadioButton3, new GridConstraints(1, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myPlaceInProjectWideRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Place in project-wide OSGi bundle output path");
        jPanel3.add((Component)jRadioButton2, new GridConstraints(2, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myPlaceInThisPathRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Place in this path:");
        jPanel3.add((Component)jRadioButton, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAdditionalJarContentsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel2, new GridConstraints(5, 0, 1, 3, 0, 3, 3, 7, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Additional Contents", (int)0, (int)0, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(6, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myFileIgnorePatternLabel = jLabel = new JLabel();
        jLabel.setText("File Ignore Pattern (regex):");
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIgnoreFilePatternPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myJarOutputPathChooser = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 2, 1, 1, 0, 1, 6, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }
}

