/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl.knopflerfish;

import com.intellij.openapi.util.io.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkInstanceManager;
import org.osmorc.frameworkintegration.impl.AbstractFrameworkInstanceManager;
import org.osmorc.run.ui.SelectedBundle;

public class KnopflerfishInstanceManager
extends AbstractFrameworkInstanceManager {
    private static final String[] BUNDLE_DIRS = new String[]{"knopflerfish.org/osgi", "knopflerfish.org/osgi/jars/*", "osgi", "osgi/jars/*", "bundles"};
    private static final Pattern SYSTEM_BUNDLE = Pattern.compile("framework.*\\.jar");
    private static final Pattern SHELL_BUNDLES = Pattern.compile("(log_api|cm_api|console_all|consoletty|frameworkcommands).*\\.jar");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public String getVersion(@NotNull FrameworkInstanceDefinition instance) {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "org/osmorc/frameworkintegration/impl/knopflerfish/KnopflerfishInstanceManager", "getVersion"));
        }
        Collection<SelectedBundle> bundles = this.getFrameworkBundles(instance, FrameworkInstanceManager.FrameworkBundleType.SYSTEM);
        if (bundles.size() != 1) return null;
        String path = bundles.iterator().next().getBundlePath();
        if (path == null) return null;
        try {
            JarFile jar = new JarFile(path);
            try {
                ZipEntry entry = jar.getEntry("release");
                if (entry == null) return null;
                String string = FileUtil.loadTextAndClose((InputStream)jar.getInputStream(entry));
                return string;
            }
            finally {
                jar.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<SelectedBundle> getFrameworkBundles(@NotNull FrameworkInstanceDefinition instance, @NotNull FrameworkInstanceManager.FrameworkBundleType type) {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "org/osmorc/frameworkintegration/impl/knopflerfish/KnopflerfishInstanceManager", "getFrameworkBundles"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/osmorc/frameworkintegration/impl/knopflerfish/KnopflerfishInstanceManager", "getFrameworkBundles"));
        }
        Collection<SelectedBundle> collection = this.collectBundles(instance, type, BUNDLE_DIRS, SYSTEM_BUNDLE, "org.knopflerfish.framework.Main", 1, SHELL_BUNDLES, null, 5);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/frameworkintegration/impl/knopflerfish/KnopflerfishInstanceManager", "getFrameworkBundles"));
        }
        return collection;
    }
}

